/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IControlModule;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.ModbusUtil;

public class P42ModbusControlModule
extends AbstractControlModule
implements IControlModule {
    public P42ModbusControlModule(Object handler) {
        super(handler);
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        int modVal;
        int modAddr = -1;
        int n = modVal = isEnable ? 1 : 0;
        if (x.equals("MpptFunc")) {
            modAddr = 22;
        } else if (x.equals("AutoTurnOn")) {
            modAddr = 23;
        } else if (x.equals("1Phase/2Phase Output")) {
            modAddr = 24;
        } else if (x.equals("DryRunningProtect")) {
            modAddr = 60;
            modVal = isEnable ? 0 : 1;
        }
        return this.setCommand(modAddr, modVal);
    }

    @Override
    public boolean setMotorRatedFrequency(double value) {
        int modVal = (int)(value * 100.0);
        return this.setCommand(2, modVal);
    }

    @Override
    public boolean setMaxFrequencyLimit(double value) {
        int modVal = (int)(value * 100.0);
        return this.setCommand(5, modVal);
    }

    @Override
    public boolean setMotorRatedPower(double value) {
        return this.setCommand(1, (int)value);
    }

    @Override
    public boolean setMotorRatedVoltage(double value) {
        int modVal = (int)(value * 10.0);
        return this.setCommand(3, modVal);
    }

    @Override
    public boolean setMotorRatedCurrent(double value) {
        int modVal = (int)(value * 100.0);
        return this.setCommand(4, modVal);
    }

    @Override
    public boolean setMinFrequencyLimit(double value) {
        int modVal = (int)(value * 100.0);
        return this.setCommand(6, modVal);
    }

    @Override
    public boolean setMaxCurrentLimit(double value) {
        return this.setCommand(7, (int)value);
    }

    @Override
    public boolean setMaxCurrentControlKp(double value) {
        return this.setCommand(8, (int)value);
    }

    @Override
    public boolean setMaxCurrentControlKi(double value) {
        return this.setCommand(9, (int)value);
    }

    @Override
    public boolean setOverLoadProtectionSixtySec(double value) {
        return this.setCommand(10, (int)value);
    }

    @Override
    public boolean setOverLoadProtectionOnMotor(double value) {
        return this.setCommand(11, (int)value);
    }

    @Override
    public boolean setVoltageForTorqueIncreasing(double value) {
        return this.setCommand(12, (int)value);
    }

    @Override
    public boolean setUnderDcVoltageProtection(double value) {
        int modVal = (int)(value * 10.0);
        return this.setCommand(14, modVal);
    }

    @Override
    public boolean setOverDcVoltageProtection(double value) {
        int modVal = (int)(value * 10.0);
        return this.setCommand(13, modVal);
    }

    @Override
    public boolean setPvReferenceVoltage(double value) {
        int modVal = (int)(value * 10.0);
        return this.setCommand(15, modVal);
    }

    @Override
    public boolean setPvEnergyWeakSleepTime(double value) {
        return this.setCommand(16, (int)value);
    }

    @Override
    public boolean setDryRunningSleepTime(double value) {
        return this.setCommand(17, (int)value);
    }

    @Override
    public boolean setOverTemperatureFault(double value) {
        return this.setCommand(18, (int)value);
    }

    @Override
    public boolean setOverTemperatureWarning(double value) {
        return this.setCommand(19, (int)value);
    }

    @Override
    public boolean setMotorAccelerationTime(double value) {
        return this.setCommand(20, (int)value);
    }

    @Override
    public boolean setMotorDecelerationTime(double value) {
        return this.setCommand(21, (int)value);
    }

    @Override
    public boolean setPF() {
        return this.setCommand(26, 1);
    }

    @Override
    public boolean setInputSource(String value) {
        int inputSource = 0;
        if (value.equals("PV")) {
            inputSource = 0;
        } else if (value.equals("AC")) {
            inputSource = 1;
        }
        return this.setCommand(24, inputSource);
    }

    @Override
    public boolean setRemoteControl(double value) {
        return this.setCommand(61, (int)value);
    }

    @Override
    public boolean setResetFault(double value) {
        return this.setCommand(65, (int)value);
    }

    public boolean setCommand(int address, int value) {
        boolean result = false;
        try {
            this.excuteCommand(address, value);
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void excuteCommand(int address, int value) throws Exception {
        byte[] bytes = ModbusUtil.shortToRegister((short)((short)value));
        SimpleRegister reg = new SimpleRegister(bytes[0], bytes[1]);
        ((ModbusHandler)this.getHandler()).writeMultipleRegisters(address, new Register[]{reg});
    }

    @Override
    public boolean setDryRunningPermitTime(double value) {
        return this.setCommand(83, (int)value);
    }

    @Override
    public boolean setOutput1Phase3Phase(double value) {
        return this.setCommand(25, (int)value);
    }
}

