/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MoreInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.PurchaseInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.modbusprocessor.ModbusAddress;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import java.util.ArrayList;
import java.util.List;
import net.wimpi.modbus.procimg.Register;

public class P42
implements IProtocol {
    public String serialNo = "";
    public static String machineType = "";
    private List<ControlRelation> relalist = new ArrayList<ControlRelation>();
    public ModbusHandler handler;

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof ModbusHandler) {
            return this.matchModbus((ModbusHandler)handler);
        }
        return false;
    }

    public boolean matchModbus(ModbusHandler modbus) {
        boolean result = false;
        try {
            String pid = "";
            Register[] regs = modbus.readMultipleRegisters(ModbusAddress.prod_id, 1);
            if (regs != null && regs.length == 1) {
                pid = new String(regs[0].toBytes());
                pid = "P" + pid;
            }
            if (pid.equals("P42")) {
                this.serialNo = modbus.getSerialNo();
                machineType = modbus.getMachineType();
            }
            if (!this.serialNo.isEmpty()) {
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getProtocolID() {
        return "P42";
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public String getMachineType() {
        return machineType;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("SN:", "{machineInfo.getSerialNo}", ""));
        infos.add(new AutoLabelItem("message.deviceid[:]", "{machineInfo.getMachineID}", ""));
        infos.add(new AutoLabelItem("message.maincpuversion[:]", "{machineInfo.getFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.outputRateVA[:]", "{machineInfo.getRatedOutputPower}", "W"));
        infos.add(new AutoLabelItem("message.nominaloutputvol[:]", "{machineInfo.getRatedOutputVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominaloutputfre[:]", "{machineInfo.getRatedOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.nominaloutputcur[:]", "{machineInfo.getRatedOutputCurrent}", "A"));
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public PurchaseInfo getPurchaseInfo() {
        return null;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("PV voltage:", "{workInfo.getInputVoltagePV}", "V"));
        item.add(new AutoLabelItem("BUS voltage:", "{workInfo.getInputVoltageBUS}", "V"));
        if (machineType.equals("11")) {
            item.add(new AutoLabelItem("UW output voltage:", "{workInfo.getOutputVoltageUV}", "V"));
            item.add(new AutoLabelItem("Line voltage:", "{workInfo.getDC2Voltage}", "V"));
        } else {
            item.add(new AutoLabelItem("UV output voltage:", "{workInfo.getOutputVoltageUV}", "V"));
        }
        item.add(new AutoLabelItem("VW output voltage:", "{workInfo.getOutputVoltageVW}", "V"));
        item.add(new AutoLabelItem("Output frequency:", "{workInfo.getOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("Total output power:", "{workInfo.getOutputPowerTotal}", "W"));
        item.add(new AutoLabelItem("Output current U:", "{workInfo.getOutputCurrentU}", "A"));
        item.add(new AutoLabelItem("Output current V:", "{workInfo.getOutputCurrentV}", "A"));
        item.add(new AutoLabelItem("Output current W:", "{workInfo.getOutputCurrentW}", "A"));
        item.add(new AutoLabelItem("Output power U:", "{workInfo.getOutputPowerU}", "W"));
        item.add(new AutoLabelItem("Output power V:", "{workInfo.getOutputPowerV}", "W"));
        item.add(new AutoLabelItem("Output power W:", "{workInfo.getOutputPowerW}", "W"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public MoreInfo getMoreInfo() {
        return null;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        return null;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("MPPT function:", "message.enable", "message.disable", "{cappbility.isMpptFunc}", "MpptFunc", false));
        list.add(new AutoRadioItem("Auto turn-on:", "message.enable", "message.disable", "{cappbility.isAutoTurnOn}", "AutoTurnOn", false));
        if (machineType.equals("11")) {
            list.add(new AutoRadioItem("1Phase/2Phase Output:", "message.enable", "message.disable", "{cappbility.isIs1Phase2PhaseOutput}", "1Phase/2Phase Output", false));
        }
        list.add(new AutoRadioItem("Dry running protection:", "open", "close", "{cappbility.isDryRunningProtect}", "DryRunningProtect", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        boolean isDisable = this.isDisable();
        list.add(new AutoSpinnerItem("Upper limit for frequency:", "{configData.getMaxFrequencyLimitMin}", "{configData.getMaxFrequencyLimitMax}", "1", "{configData.getMaxFrequencyLimit}", "Hz", "setMaxFrequencyLimit", false));
        list.add(new AutoSpinnerItem("Low limit for frequency:", "{configData.getMinFrequencyLimitMin}", "{configData.getMinFrequencyLimitMax}", "1", "{configData.getMinFrequencyLimit}", "Hz", "setMinFrequencyLimit", false));
        list.add(new AutoSpinnerItem("Motor rated power:", "{configData.getMotorRatedPowerMin}", "{configData.getMotorRatedPowerMax}", "10", "{configData.getMotorRatedPower}", "W", "setMotorRatedPower", false));
        list.add(new AutoSpinnerItem("Motor rated voltage:", "{configData.getMotorRatedVoltageMin}", "{configData.getMotorRatedVoltageMax}", "1", "{configData.getMotorRatedVoltage}", "V", "setMotorRatedVoltage", false));
        list.add(new AutoSpinnerItem("Motor rated current:", "{configData.getMotorRatedCurrentMin}", "{configData.getMotorRatedCurrentMax}", "0.1", "{configData.getMotorRatedCurrent}", "A", "setMotorRatedCurrent", false));
        list.add(new AutoSpinnerItem("Maximum current limit:", "{configData.getMaxCurrentLimitMin}", "{configData.getMaxCurrentLimitMax}", "1", "{configData.getMaxCurrentLimit}", "%", "setMaxCurrentLimit", false));
        list.add(new AutoSpinnerItem("Kp for max. current control:", "{configData.getMaxCurrentControlKpMin}", "{configData.getMaxCurrentControlKpMax}", "5", "{configData.getMaxCurrentControlKp}", "", "setMaxCurrentControlKp", false));
        list.add(new AutoSpinnerItem("Ki for max. current control:", "{configData.getMaxCurrentControlKiMin}", "{configData.getMaxCurrentControlKiMax}", "5", "{configData.getMaxCurrentControlKi}", "", "setMaxCurrentControlKi", false));
        list.add(new AutoSpinnerItem("60S overload protection:", "{configData.getOverLoadProtectionSixtySecMin}", "{configData.getOverLoadProtectionSixtySecMax}", "1", "{configData.getOverLoadProtectionSixtySec}", "%", "setOverLoadProtectionSixtySec", false));
        list.add(new AutoSpinnerItem("Output over current protection on motor:", "{configData.getOverLoadProtectionOnMotorMin}", "{configData.getOverLoadProtectionOnMotorMax}", "1", "{configData.getOverLoadProtectionOnMotor}", "%", "setOverLoadProtectionOnMotor", false));
        list.add(new AutoSpinnerItem("Voltage for torque increasing:", "{configData.getVoltageForTorqueIncreasingMin}", "{configData.getVoltageForTorqueIncreasingMax}", "1", "{configData.getVoltageForTorqueIncreasing}", "%", "setVoltageForTorqueIncreasing", false));
        list.add(new AutoSpinnerItem("Over DC voltage protection:", "{configData.getOverDcVoltageProtectionMin}", "{configData.getOverDcVoltageProtectionMax}", "1", "{configData.getOverDcVoltageProtection}", "V", "setOverDcVoltageProtection", false));
        list.add(new AutoSpinnerItem("Under DC voltage protection:", "{configData.getUnderDcVoltageProtectionMin}", "{configData.getUnderDcVoltageProtectionMax}", "1", "{configData.getUnderDcVoltageProtection}", "V", "setUnderDcVoltageProtection", false));
        list.add(new AutoSpinnerItem("PV reference voltage:", "{configData.getPvReferenceVoltageMin}", "{configData.getPvReferenceVoltageMax}", "0.1", "{configData.getPvReferenceVoltage}", "V", "setPvReferenceVoltage", false));
        list.add(new AutoSpinnerItem("Sleep time while PV energy is weak:", "{configData.getPvEnergyWeakSleepTimeMin}", "{configData.getPvEnergyWeakSleepTimeMax}", "10", "{configData.getPvEnergyWeakSleepTime}", "Sec", "setPvEnergyWeakSleepTime", false));
        list.add(new AutoSpinnerItem("Sleep time for dry running:", "{configData.getDryRunningSleepTimeMin}", "{configData.getDryRunningSleepTimeMax}", "10", "{configData.getDryRunningSleepTime}", "Sec", "setDryRunningSleepTime", false));
        list.add(new AutoSpinnerItem("Over temperature fault on inverter:", "{configData.getOverTemperatureFaultMin}", "{configData.getOverTemperatureFaultMax}", "1", "{configData.getOverTemperatureFault}", "\u2103", "setOverTemperatureFault", false));
        list.add(new AutoSpinnerItem("Over temperature warning on inverter:", "{configData.getOverTemperatureWarningMin}", "{configData.getOverTemperatureWarningMax}", "1", "{configData.getOverTemperatureWarning}", "\u2103", "setOverTemperatureWarning", false));
        list.add(new AutoSpinnerItem("Acceleration time for motor:", "{configData.getMotorAccelerationTimeMin}", "{configData.getMotorAccelerationTimeMax}", "1", "{configData.getMotorAccelerationTime}", "Sec", "setMotorAccelerationTime", false));
        list.add(new AutoSpinnerItem("Deceleration time for motor:", "{configData.getMotorDecelerationTimeMin}", "{configData.getMotorDecelerationTimeMax}", "1", "{configData.getMotorDecelerationTime}", "Sec", "setMotorDecelerationTime", false));
        list.add(new AutoSpinnerItem("Permit time for dry running:", "{configData.getDryRunningPermitTimeMin}", "{configData.getDryRunningPermitTimeMax}", "1", "{configData.getDryRunningPermitTime}", "Sec", "setDryRunningPermitTime", false));
        if (machineType.equals("11")) {
            list.add(new AutoSpinnerItem("1Phase/3PhaseOutput:", "{configData.getOutput1Phase3PhaseMin}", "{configData.getOutput1Phase3PhaseMax}", "1", "{configData.getOutput1Phase3Phase}", "", "setOutput1Phase3Phase", false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        list.add(new AutoComboBoxItem("Motor rated frequency:", new String[]{"50.0", "60.0"}, "{configData.getMotorRatedFrequency}", "Hz", "setMotorRatedFrequency", false));
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        return null;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("PV voltage", "{workInfo.getInputVoltagePV}", true, true));
        list.add(new HistoryData("BUS voltage", "{workInfo.getInputVoltageBUS}", true, true));
        if (machineType.equals("11")) {
            list.add(new HistoryData("UW output voltage", "{workInfo.getOutputVoltageUV}", true, true));
            list.add(new HistoryData("Line voltage:", "{workInfo.getDC2Voltage}", true, true));
        } else {
            list.add(new HistoryData("UV output voltage", "{workInfo.getOutputVoltageUV}", true, true));
        }
        list.add(new HistoryData("VW output voltage", "{workInfo.getOutputVoltageVW}", true, true));
        list.add(new HistoryData("Output frequency", "{workInfo.getOutputFrequency}", true, true));
        list.add(new HistoryData("Output current U", "{workInfo.getOutputCurrentU}", true, true));
        list.add(new HistoryData("Output current V", "{workInfo.getOutputCurrentV}", true, true));
        list.add(new HistoryData("Output current W", "{workInfo.getOutputCurrentW}", true, true));
        list.add(new HistoryData("Output power U", "{workInfo.getOutputPowerU}", true, true));
        list.add(new HistoryData("Output power V", "{workInfo.getOutputPowerV}", true, true));
        list.add(new HistoryData("Output power W", "{workInfo.getOutputPowerW}", true, true));
        list.add(new HistoryData("Total output power", "{workInfo.getOutputPowerTotal}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("PV voltage", "{workInfo.getInputVoltagePV}", 500.0, "V", true));
        list.add(new HistoryChart("BUS voltage", "{workInfo.getInputVoltagePV}", 100.0, "V", true));
        if (machineType.equals("11")) {
            list.add(new HistoryChart("UW output voltage", "{workInfo.getOutputVoltageUV}", 300.0, "V", false));
            list.add(new HistoryChart("Line voltage:", "{workInfo.getDC2Voltage}", 500.0, "V", true));
        } else {
            list.add(new HistoryChart("UV output voltage", "{workInfo.getOutputVoltageUV}", 300.0, "V", false));
        }
        list.add(new HistoryChart("VW output voltage", "{workInfo.getOutputVoltageVW}", 300.0, "V", false));
        list.add(new HistoryChart("Output frequency", "{workInfo.getOutputFrequency}", 70.0, "Hz", false));
        list.add(new HistoryChart("Output current U", "{workInfo.getOutputCurrentU}", 250.0, "A", false));
        list.add(new HistoryChart("Output current V", "{workInfo.getOutputCurrentV}", 250.0, "A", false));
        list.add(new HistoryChart("Output current W", "{workInfo.getOutputCurrentW}", 250.0, "A", false));
        list.add(new HistoryChart("Output power U", "{workInfo.getOutputPowerU}", 3000.0, "W", false));
        list.add(new HistoryChart("Output power V", "{workInfo.getOutputPowerV}", 3000.0, "W", false));
        list.add(new HistoryChart("Output power W", "{workInfo.getOutputPowerW}", 3000.0, "W", false));
        list.add(new HistoryChart("Total output power", "{workInfo.getOutputPowerTotal}", 10000.0, "W", false));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.realTimeCtrl", 204, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), null));
        menus.add(new AutoMenuOne("message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public List<ControlRelation> getRelationList() {
        return this.relalist;
    }

    @Override
    public void setRelationList() {
        this.relalist.clear();
        this.relalist.add(new ControlRelation("setMaxFrequencyLimit", 0, "setMinFrequencyLimit", 0, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setMinFrequencyLimit", 0, "setMaxFrequencyLimit", 0, ControlRelation.RELATION_MIN));
        this.relalist.add(new ControlRelation("setOverDcVoltageProtection", 0, "setUnderDcVoltageProtection", 0, ControlRelation.RELATION_MAX));
        this.relalist.add(new ControlRelation("setUnderDcVoltageProtection", 0, "setOverDcVoltageProtection", 0, ControlRelation.RELATION_MIN));
    }

    @Override
    public boolean isDisable() {
        WorkInfo workinfo;
        boolean isDisable = false;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null && !(workinfo = (WorkInfo)processor.getBeanBag().getBean("workinfo")).getWorkMode().equals("Standby Mode")) {
            isDisable = true;
        }
        return isDisable;
    }
}

