/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.system.GlobalVariables;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VolUtil {
    public static final SimpleDateFormat FORMAT_TIMESTAMP = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getFormatTimestamp(Date date) {
        return FORMAT_TIMESTAMP.format(date);
    }

    public static int parseInt(String str) {
        int value = 0;
        if (str == null || str.equals("")) {
            return value;
        }
        try {
            value = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static double parseDouble(String str) {
        double value = 0.0;
        if (str == null || str.equals("")) {
            return value;
        }
        try {
            value = Double.parseDouble(str.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static float parseFloat(String str) {
        float value = 0.0f;
        if (str == null || str.equals("")) {
            return value;
        }
        try {
            value = Float.parseFloat(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean parseBoolean(String str) {
        boolean value = false;
        if (str == null || str.equals("")) {
            return value;
        }
        try {
            value = Boolean.parseBoolean(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static boolean checkEmailLenth(String value, int length) {
        return value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*") && value.length() <= length;
    }

    public static boolean checkEmail(String value) {
        return value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    }

    public static boolean checkURL(String value) {
        return value.matches("[a-zA-z]+://[^\\s]*");
    }

    public static boolean checkIP(String value) {
        return value.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    }

    public static boolean checkIPSec(String value) {
        return value.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])");
    }

    public static boolean checkNull(String value) {
        return value == null || "".equals(value.trim());
    }

    public static boolean checkNumeric(String str) {
        if (str == null || "".equalsIgnoreCase(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPhoneNum(String str) {
        if (str == null || "".equalsIgnoreCase(str) || str.startsWith("-") || str.endsWith("-")) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static String leftZero(String value, int len) {
        if (value.length() > len || len == 0) {
            return value;
        }
        StringBuffer result = new StringBuffer();
        int item = 0;
        while (item < len - value.length()) {
            result.append("0");
            ++item;
        }
        return result.append(value).toString();
    }

    public static double round(double value, int scale) {
        BigDecimal temp = new BigDecimal(Double.toString(value));
        return temp.setScale(scale, 4).doubleValue();
    }

    public static void setTempMachine(WorkInfo workInfo) {
        if (workInfo.getWorkMode() != null && workInfo.getWorkMode().length() > 0 && GlobalVariables.globalConfig.getTemperFormat().equals("Fahrenheit")) {
            try {
                double v = workInfo.getTempMachine();
                double temp = v * 1.8 + 32.0;
                workInfo.setTempMachine(VolUtil.round(temp, 1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setTempEnvironment(WorkInfo workInfo) {
        if (workInfo.getWorkMode() != null && workInfo.getWorkMode().length() > 0 && GlobalVariables.globalConfig.getTemperFormat().equals("Fahrenheit")) {
            try {
                double v = workInfo.getTempEnvironment();
                double temp = v * 1.8 + 32.0;
                workInfo.setTempEnvironment(VolUtil.round(temp, 1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getTempUnit() {
        String unitText = "\u2103";
        if (GlobalVariables.globalConfig.getTemperFormat().equals("Fahrenheit")) {
            unitText = "\u2109";
        }
        return unitText;
    }

    public static String getTemperature(String temperature) {
        if (GlobalVariables.globalConfig.getTemperFormat().equals("Fahrenheit")) {
            float temp = 0.0f;
            try {
                float v = Float.parseFloat(temperature);
                temp = (float)((double)v * 1.8 + 32.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.valueOf(VolUtil.round(temp, 1));
        }
        return temperature;
    }

    public static String commandAndParaIndex(String command, int paraindex) {
        return String.valueOf(command) + "+" + paraindex;
    }

    public static void main(String[] args) {
        System.out.println(VolUtil.parseDouble("29.1"));
    }
}

