/*
 * Decompiled with CFR 0.152.
 */
package usb;

import cn.com.voltronic.solar.socket.SystemTrayUDPClient;
import cn.com.voltronic.solar.system.ShutdownInterface;
import cn.com.voltronic.solar.util.UPSCmdutils;
import java.io.File;
import usb.IUSBComm;

public class MacUSBRemote
implements ShutdownInterface,
IUSBComm {
    private SystemTrayUDPClient client;
    private Object lock = new Integer(1);

    public MacUSBRemote() {
        this.client = new SystemTrayUDPClient("localhost", 33656);
        this.startUSBSRVTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUSBSRVTest() {
        Object object = this.lock;
        synchronized (object) {
            boolean success = false;
            try {
                String result = "";
                this.client.send("TEST".getBytes());
                result = this.client.receiveString().trim();
                if (result.equals("(ACK")) {
                    success = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!success) {
                try {
                    String file = String.valueOf(System.getProperty("user.dir")) + File.separator + "lib" + File.separator + "startusb.sh";
                    Runtime.getRuntime().exec(file);
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized String sendCommand(String userId, String command) {
        if (userId.trim().length() == 0) {
            return "";
        }
        String result = "";
        try {
            this.startUSBSRVTest();
            String cmd = UPSCmdutils.cmdtoString(userId, command);
            this.client.send(cmd.getBytes());
            StringBuilder sb = new StringBuilder();
            byte ch = 0;
            byte[] bytes = this.client.receive();
            if (bytes != null) {
                int i = 0;
                while (i < bytes.length) {
                    ch = bytes[i];
                    if (ch == 13) break;
                    sb.append((char)ch);
                    ++i;
                }
                result = sb.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public synchronized String findUSBDevices() {
        String result = "";
        try {
            this.startUSBSRVTest();
            String cmd = "findUSBDevices";
            this.client.send(cmd.getBytes());
            result = this.client.receiveString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public synchronized void shutdownOS() {
        try {
            this.startUSBSRVTest();
            String cmd = "shutdownOS";
            this.client.send(cmd.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void beep(int time) {
        try {
            this.startUSBSRVTest();
            String cmd = UPSCmdutils.actiontoString("beep", "3");
            this.client.send(cmd.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void suspendOS() {
        try {
            this.startUSBSRVTest();
            String cmd = "suspendOS";
            this.client.send(cmd.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void closeUSBPort(String usbID) {
        try {
            if (usbID.trim().length() == 0) {
                return;
            }
            this.startUSBSRVTest();
            String cmd = UPSCmdutils.actiontoString("closeUSBPort", usbID);
            this.client.send(cmd.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

