/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.springframework.util.Assert;

public abstract class NumberUtils {
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;

    public static Number convertNumberToTargetClass(Number number, Class clazz) throws IllegalArgumentException {
        Assert.notNull(number, "Number must not be null");
        Assert.notNull(clazz, "Target class must not be null");
        if (clazz.isInstance(number)) {
            return number;
        }
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            long l = number.longValue();
            if (l < -128L || l > 127L) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return new Byte(number.byteValue());
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            long l = number.longValue();
            if (l < -32768L || l > 32767L) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return new Short(number.shortValue());
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            long l = number.longValue();
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, clazz);
            }
            return new Integer(number.intValue());
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(number.longValue());
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(number.floatValue());
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(number.doubleValue());
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BigInteger.valueOf(number.longValue());
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + clazz.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class clazz) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + clazz.getName() + "]: overflow");
    }

    public static Number parseNumber(String string, Class clazz) {
        Assert.notNull(string, "Text must not be null");
        Assert.notNull(clazz, "Target class must not be null");
        String string2 = string.trim();
        if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.decode(string2);
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.decode(string2);
        }
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.decode(string2);
        }
        if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.decode(string2);
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return NumberUtils.decodeBigInteger(string2);
        }
        if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.valueOf(string2);
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.valueOf(string2);
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || clazz.equals(class$java$lang$Number == null ? (class$java$lang$Number = NumberUtils.class$("java.lang.Number")) : class$java$lang$Number)) {
            return new BigDecimal(string2);
        }
        throw new IllegalArgumentException("Cannot convert String [" + string + "] to target class [" + clazz.getName() + "]");
    }

    public static Number parseNumber(String string, Class clazz, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull(string, "Text must not be null");
            Assert.notNull(clazz, "Target class must not be null");
            try {
                Number number = numberFormat.parse(string.trim());
                return NumberUtils.convertNumberToTargetClass(number, clazz);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException.getMessage());
            }
        }
        return NumberUtils.parseNumber(string, clazz);
    }

    private static BigInteger decodeBigInteger(String string) {
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        BigInteger bigInteger = new BigInteger(string.substring(n2), n);
        return bl ? bigInteger.negate() : bigInteger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

