/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class InlineImageUtils {
    private static final Map<PdfName, PdfName> inlineImageEntryAbbreviationMap = new HashMap<PdfName, PdfName>();
    private static final Map<PdfName, PdfName> inlineImageColorSpaceAbbreviationMap;
    private static final Map<PdfName, PdfName> inlineImageFilterAbbreviationMap;

    private InlineImageUtils() {
    }

    public static PdfImageObject parseInlineImage(PdfContentParser ps) throws IOException {
        PdfDictionary inlineImageDictionary = InlineImageUtils.parseInlineImageDictionary(ps);
        byte[] samples = InlineImageUtils.parseInlineImageSamples(inlineImageDictionary, ps);
        return new PdfImageObject(inlineImageDictionary, samples);
    }

    private static PdfDictionary parseInlineImageDictionary(PdfContentParser ps) throws IOException {
        PdfDictionary dictionary = new PdfDictionary();
        PdfObject key = ps.readPRObject();
        while (key != null && !"ID".equals(key.toString())) {
            PdfObject value = ps.readPRObject();
            PdfName resolvedKey = inlineImageEntryAbbreviationMap.get(key);
            if (resolvedKey == null) {
                resolvedKey = (PdfName)key;
            }
            dictionary.put(resolvedKey, InlineImageUtils.getAlternateValue(resolvedKey, value));
            key = ps.readPRObject();
        }
        int ch = ps.getTokeniser().read();
        if (!PRTokeniser.isWhitespace(ch)) {
            throw new IOException("Unexpected character " + ch + " found after ID in inline image");
        }
        return dictionary;
    }

    private static PdfObject getAlternateValue(PdfName key, PdfObject value) {
        PdfName altValue;
        if (key == PdfName.FILTER) {
            if (value instanceof PdfName) {
                PdfName altValue2 = inlineImageFilterAbbreviationMap.get(value);
                if (altValue2 != null) {
                    return altValue2;
                }
            } else if (value instanceof PdfArray) {
                PdfArray array = (PdfArray)value;
                PdfArray altArray = new PdfArray();
                int count = array.size();
                for (int i = 0; i < count; ++i) {
                    altArray.add(InlineImageUtils.getAlternateValue(key, array.getPdfObject(i)));
                }
                return altArray;
            }
        } else if (key == PdfName.COLORSPACE && (altValue = inlineImageColorSpaceAbbreviationMap.get(value)) != null) {
            return altValue;
        }
        return value;
    }

    private static int getComponentsPerPixel(PdfName colorSpaceName) {
        if (colorSpaceName == null) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DEVICEGRAY)) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DEVICERGB)) {
            return 3;
        }
        if (colorSpaceName.equals(PdfName.DEVICECMYK)) {
            return 4;
        }
        throw new IllegalArgumentException("Unexpected color space " + colorSpaceName);
    }

    private static int computeBytesPerRow(PdfDictionary imageDictionary) {
        PdfNumber wObj = imageDictionary.getAsNumber(PdfName.WIDTH);
        PdfNumber bpcObj = imageDictionary.getAsNumber(PdfName.BITSPERCOMPONENT);
        int cpp = InlineImageUtils.getComponentsPerPixel(imageDictionary.getAsName(PdfName.COLORSPACE));
        int w = wObj.intValue();
        int bpc = bpcObj != null ? bpcObj.intValue() : 1;
        int bytesPerRow = (w * bpc * cpp + 7) / 8;
        return bytesPerRow;
    }

    private static byte[] parseUnfilteredSamples(PdfDictionary imageDictionary, PdfContentParser ps) throws IOException {
        if (imageDictionary.contains(PdfName.FILTER)) {
            throw new IllegalArgumentException("Dictionary contains filters");
        }
        PdfNumber h = imageDictionary.getAsNumber(PdfName.HEIGHT);
        int bytesToRead = InlineImageUtils.computeBytesPerRow(imageDictionary) * h.intValue();
        byte[] bytes = new byte[bytesToRead];
        PRTokeniser tokeniser = ps.getTokeniser();
        int shouldBeWhiteSpace = tokeniser.read();
        int startIndex = 0;
        if (!PRTokeniser.isWhitespace(shouldBeWhiteSpace)) {
            bytes[0] = (byte)shouldBeWhiteSpace;
            ++startIndex;
        }
        for (int i = startIndex; i < bytesToRead; ++i) {
            int ch = tokeniser.read();
            if (ch == -1) {
                throw new InlineImageParseException("End of content stream reached before end of image data");
            }
            bytes[i] = (byte)ch;
        }
        PdfObject ei = ps.readPRObject();
        if (!ei.toString().equals("EI")) {
            throw new InlineImageParseException("EI not found after end of image data");
        }
        return bytes;
    }

    private static byte[] parseInlineImageSamples(PdfDictionary imageDictionary, PdfContentParser ps) throws IOException {
        int ch;
        if (!imageDictionary.contains(PdfName.FILTER)) {
            return InlineImageUtils.parseUnfilteredSamples(imageDictionary, ps);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream accumulated = new ByteArrayOutputStream();
        int found = 0;
        PRTokeniser tokeniser = ps.getTokeniser();
        while ((ch = tokeniser.read()) != -1) {
            if (found == 0 && PRTokeniser.isWhitespace(ch)) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 1 && ch == 69) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 1 && PRTokeniser.isWhitespace(ch)) {
                baos.write(accumulated.toByteArray());
                accumulated.reset();
                accumulated.write(ch);
                continue;
            }
            if (found == 2 && ch == 73) {
                ++found;
                accumulated.write(ch);
                continue;
            }
            if (found == 3 && PRTokeniser.isWhitespace(ch)) {
                return baos.toByteArray();
            }
            baos.write(accumulated.toByteArray());
            accumulated.reset();
            baos.write(ch);
            found = 0;
        }
        throw new InlineImageParseException("Could not find image data or EI");
    }

    static {
        inlineImageEntryAbbreviationMap.put(PdfName.BITSPERCOMPONENT, PdfName.BITSPERCOMPONENT);
        inlineImageEntryAbbreviationMap.put(PdfName.COLORSPACE, PdfName.COLORSPACE);
        inlineImageEntryAbbreviationMap.put(PdfName.DECODE, PdfName.DECODE);
        inlineImageEntryAbbreviationMap.put(PdfName.DECODEPARMS, PdfName.DECODEPARMS);
        inlineImageEntryAbbreviationMap.put(PdfName.FILTER, PdfName.FILTER);
        inlineImageEntryAbbreviationMap.put(PdfName.HEIGHT, PdfName.HEIGHT);
        inlineImageEntryAbbreviationMap.put(PdfName.IMAGEMASK, PdfName.IMAGEMASK);
        inlineImageEntryAbbreviationMap.put(PdfName.INTENT, PdfName.INTENT);
        inlineImageEntryAbbreviationMap.put(PdfName.INTERPOLATE, PdfName.INTERPOLATE);
        inlineImageEntryAbbreviationMap.put(PdfName.WIDTH, PdfName.WIDTH);
        inlineImageEntryAbbreviationMap.put(new PdfName("BPC"), PdfName.BITSPERCOMPONENT);
        inlineImageEntryAbbreviationMap.put(new PdfName("CS"), PdfName.COLORSPACE);
        inlineImageEntryAbbreviationMap.put(new PdfName("D"), PdfName.DECODE);
        inlineImageEntryAbbreviationMap.put(new PdfName("DP"), PdfName.DECODEPARMS);
        inlineImageEntryAbbreviationMap.put(new PdfName("F"), PdfName.FILTER);
        inlineImageEntryAbbreviationMap.put(new PdfName("H"), PdfName.HEIGHT);
        inlineImageEntryAbbreviationMap.put(new PdfName("IM"), PdfName.IMAGEMASK);
        inlineImageEntryAbbreviationMap.put(new PdfName("I"), PdfName.INTERPOLATE);
        inlineImageEntryAbbreviationMap.put(new PdfName("W"), PdfName.WIDTH);
        inlineImageColorSpaceAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("G"), PdfName.DEVICEGRAY);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("RGB"), PdfName.DEVICERGB);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("CMYK"), PdfName.DEVICECMYK);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("I"), PdfName.INDEXED);
        inlineImageFilterAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageFilterAbbreviationMap.put(new PdfName("AHx"), PdfName.ASCIIHEXDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("A85"), PdfName.ASCII85DECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("LZW"), PdfName.LZWDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("Fl"), PdfName.FLATEDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("RL"), PdfName.RUNLENGTHDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("CCF"), PdfName.CCITTFAXDECODE);
        inlineImageFilterAbbreviationMap.put(new PdfName("DCT"), PdfName.DCTDECODE);
    }

    public static class InlineImageParseException
    extends IOException {
        public InlineImageParseException(String message) {
            super(message);
        }
    }
}

