/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

class BaudRate
extends Choice
implements ItemListener {
    private SerialPortDisplay owner;

    public BaudRate(SerialPortDisplay serialPortDisplay) {
        this.add("Unknown");
        this.add("50");
        this.add("75");
        this.add("110");
        this.add("134");
        this.add("150");
        this.add("200");
        this.add("300");
        this.add("600");
        this.add("1200");
        this.add("1800");
        this.add("2400");
        this.add("4800");
        this.add("9600");
        this.add("19200");
        this.add("28800");
        this.add("38400");
        this.add("57600");
        this.add("115200");
        this.addItemListener((ItemListener)this);
        this.owner = serialPortDisplay;
    }

    protected void showValue() {
        SerialPort serialPort = this.owner.port;
        if (this.owner.open) {
            this.select(new Integer(serialPort.getBaudRate()).toString());
        } else {
            this.select("Unknown");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        if (string.equals("Unknown")) {
            this.showValue();
            return;
        }
        n = new Integer(string);
        SerialPort serialPort = this.owner.port;
        if (n > 0 && serialPort != null) {
            try {
                serialPort.setSerialPortParams(n, serialPort.getDataBits(), serialPort.getStopBits(), serialPort.getParity());
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                System.out.println("Cannot set baud rate to " + string + " for port " + serialPort.getName());
            }
        }
        this.owner.showValues();
    }
}

