/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;

public class SerialDemo
extends Frame
implements ActionListener {
    final int HEIGHT = 450;
    final int WIDTH = 410;
    private MenuBar mb;
    private Menu fileMenu;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem exitItem;
    private Button openButton;
    private Button closeButton;
    private Button breakButton;
    private Panel buttonPanel;
    private Panel messagePanel;
    private TextArea messageAreaOut;
    private TextArea messageAreaIn;
    private ConfigurationPanel configurationPanel;
    private SerialParameters parameters = new SerialParameters();
    private SerialConnection connection;
    private Properties props = null;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && (stringArray[0].equals("-h") || stringArray[0].equals("-help"))) {
            System.out.println("usage: java SerialDemo [configuration File]");
            System.exit(1);
        }
        SerialDemo serialDemo = new SerialDemo(stringArray);
        serialDemo.setVisible(true);
        serialDemo.repaint();
    }

    public SerialDemo(String[] stringArray) {
        super("Serial Demo");
        this.addWindowListener((WindowListener)new CloseHandler(this, this));
        this.mb = new MenuBar();
        this.fileMenu = new Menu("File");
        this.openItem = new MenuItem("Load");
        this.openItem.addActionListener((ActionListener)this);
        this.fileMenu.add(this.openItem);
        this.saveItem = new MenuItem("Save");
        this.saveItem.addActionListener((ActionListener)this);
        this.fileMenu.add(this.saveItem);
        this.exitItem = new MenuItem("Exit");
        this.exitItem.addActionListener((ActionListener)this);
        this.fileMenu.add(this.exitItem);
        this.mb.add(this.fileMenu);
        this.setMenuBar(this.mb);
        this.messagePanel = new Panel();
        this.messagePanel.setLayout(new GridLayout(2, 1));
        this.messageAreaOut = new TextArea();
        this.messagePanel.add(this.messageAreaOut);
        this.messageAreaIn = new TextArea();
        this.messageAreaIn.setEditable(false);
        this.messagePanel.add(this.messageAreaIn);
        this.add((Component)this.messagePanel, (Object)"Center");
        this.configurationPanel = new ConfigurationPanel(this, (Frame)this);
        this.buttonPanel = new Panel();
        this.openButton = new Button("Open Port");
        this.openButton.addActionListener((ActionListener)this);
        this.buttonPanel.add(this.openButton);
        this.closeButton = new Button("Close Port");
        this.closeButton.addActionListener((ActionListener)this);
        this.closeButton.setEnabled(false);
        this.buttonPanel.add(this.closeButton);
        this.breakButton = new Button("Send Break");
        this.breakButton.addActionListener((ActionListener)this);
        this.breakButton.setEnabled(false);
        this.buttonPanel.add(this.breakButton);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)this.configurationPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.configurationPanel);
        gridBagLayout.setConstraints(this.buttonPanel, gridBagConstraints);
        panel.add(this.buttonPanel);
        this.add((Component)panel, (Object)"South");
        this.parseArgs(stringArray);
        this.connection = new SerialConnection(this, this.parameters, this.messageAreaOut, this.messageAreaIn);
        this.setConfigurationPanel();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - 205, dimension.height / 2 - 225);
        this.setSize(410, 450);
    }

    public void setConfigurationPanel() {
        this.configurationPanel.setConfigurationPanel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        Serializable serializable;
        String string3 = actionEvent.getActionCommand();
        if (string3.equals("Load")) {
            if (this.connection.isOpen()) {
                serializable = new AlertDialog((Frame)this, "Port Open!", "Configuration may not", "be loaded", "while a port is open.");
            } else {
                serializable = new FileDialog((Frame)this, "Load Port Configuration", 0);
                ((Dialog)serializable).setVisible(true);
                string2 = ((FileDialog)serializable).getFile();
                if (string2 != null) {
                    string = ((FileDialog)serializable).getDirectory();
                    File file = new File(string + string2);
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        this.props = new Properties();
                        this.props.load(fileInputStream);
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println(fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                    }
                    this.loadParams();
                }
            }
        }
        if (string3.equals("Save")) {
            this.configurationPanel.setParameters();
            serializable = new FileDialog((Frame)this, "Save Port Configuration", 1);
            ((FileDialog)serializable).setFile("serialdemo.properties");
            ((Dialog)serializable).setVisible(true);
            string2 = ((FileDialog)serializable).getFile();
            string = ((FileDialog)serializable).getDirectory();
            if (string2 != null && string != null) {
                this.writeFile(string + string2);
            }
        }
        if (string3.equals("Exit")) {
            this.shutdown();
        }
        if (string3.equals("Open Port")) {
            this.openButton.setEnabled(false);
            serializable = this.getCursor();
            this.setNewCursor(Cursor.getPredefinedCursor(3));
            this.configurationPanel.setParameters();
            try {
                this.connection.openConnection();
            }
            catch (SerialConnectionException serialConnectionException) {
                string = new AlertDialog((Frame)this, "Error Opening Port!", "Error opening port,", serialConnectionException.getMessage() + ".", "Select new settings, try again.");
                this.openButton.setEnabled(true);
                this.setNewCursor((Cursor)serializable);
                return;
            }
            this.portOpened();
            this.setNewCursor((Cursor)serializable);
        }
        if (string3.equals("Close Port")) {
            this.portClosed();
        }
        if (string3.equals("Send Break")) {
            this.connection.sendBreak();
        }
    }

    public synchronized void writeProps(Properties properties, String string) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        boolean bl = false;
        if (string != null) {
            printWriter.write(35);
            printWriter.println(string);
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            printWriter.print(string2);
            printWriter.write(61);
            String string3 = (String)properties.get(string2);
            int n = string3.length();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                char c = string3.charAt(i);
                switch (c) {
                    case '\\': {
                        printWriter.write(92);
                        printWriter.write(92);
                        break;
                    }
                    case '\t': {
                        printWriter.write(92);
                        printWriter.write(116);
                        break;
                    }
                    case '\n': {
                        printWriter.write(92);
                        printWriter.write(110);
                        break;
                    }
                    case '\r': {
                        printWriter.write(92);
                        printWriter.write(114);
                        break;
                    }
                    default: {
                        printWriter.write(c);
                    }
                }
                bl2 = false;
            }
            printWriter.write(10);
        }
    }

    public void portOpened() {
        this.openButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        this.breakButton.setEnabled(true);
    }

    public void portClosed() {
        this.connection.closeConnection();
        this.openButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.breakButton.setEnabled(false);
    }

    private void setNewCursor(Cursor cursor) {
        this.setCursor(cursor);
        this.messageAreaIn.setCursor(cursor);
        this.messageAreaOut.setCursor(cursor);
    }

    private void writeFile(String string) {
        FileOutputStream fileOutputStream = null;
        Properties properties = new Properties();
        properties.put("portName", this.parameters.getPortName());
        properties.put("baudRate", this.parameters.getBaudRateString());
        properties.put("flowControlIn", this.parameters.getFlowControlInString());
        properties.put("flowControlOut", this.parameters.getFlowControlOutString());
        properties.put("parity", this.parameters.getParityString());
        properties.put("databits", this.parameters.getDatabitsString());
        properties.put("stopbits", this.parameters.getStopbitsString());
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for writiing");
        }
        try {
            this.writeProps(properties, "Serial Demo poperties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not close file for writiing");
        }
    }

    private void shutdown() {
        this.connection.closeConnection();
        System.exit(1);
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length < 1) {
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            file = new File(System.getProperty("user.dir") + System.getProperty("path.separator") + stringArray[0]);
        }
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.props = new Properties();
                this.props.load(fileInputStream);
                fileInputStream.close();
                this.loadParams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadParams() {
        this.parameters.setPortName(this.props.getProperty("portName"));
        this.parameters.setBaudRate(this.props.getProperty("baudRate"));
        this.parameters.setFlowControlIn(this.props.getProperty("flowControlIn"));
        this.parameters.setFlowControlOut(this.props.getProperty("flowControlOut"));
        this.parameters.setParity(this.props.getProperty("parity"));
        this.parameters.setDatabits(this.props.getProperty("databits"));
        this.parameters.setStopbits(this.props.getProperty("stopbits"));
        this.setConfigurationPanel();
    }

    static /* synthetic */ SerialParameters access$000(SerialDemo serialDemo) {
        return serialDemo.parameters;
    }

    static /* synthetic */ SerialConnection access$100(SerialDemo serialDemo) {
        return serialDemo.connection;
    }

    static /* synthetic */ void access$200(SerialDemo serialDemo) {
        serialDemo.shutdown();
    }
}

