/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import javax.comm.ParallelPort;

public class Transmitter
extends Panel
implements TextListener,
ItemListener,
Runnable {
    private Panel p;
    private Panel p1;
    private TextArea text;
    private Checkbox auto;
    private ByteStatistics counter;
    private ParallelPortDisplay owner;
    private Thread thr;
    private Color onColor;
    private Color offColor;
    private boolean first = true;
    static String testString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\nabcdefghijklmnopqrstuvwxyz\r\n1234567890\r\n";

    public Transmitter(ParallelPortDisplay parallelPortDisplay, int n, int n2) {
        this.owner = parallelPortDisplay;
        this.setLayout((LayoutManager)new BorderLayout());
        this.p = new Panel();
        this.p.setLayout(new FlowLayout());
        this.p1 = new Panel();
        this.p1.setLayout(new BorderLayout());
        this.p1.add("West", new Label("Auto Transmit"));
        this.auto = new Checkbox();
        this.auto.addItemListener((ItemListener)this);
        this.p1.add("East", this.auto);
        this.p.add(this.p1);
        this.add("North", (Component)this.p);
        this.text = new TextArea(n, n2);
        this.text.append("Type here");
        this.text.addTextListener((TextListener)this);
        this.add("Center", (Component)this.text);
        this.counter = new ByteStatistics("Bytes Sent", 10, parallelPortDisplay.port, false);
        this.add("South", (Component)this.counter);
        this.thr = null;
        this.onColor = Color.green;
        this.offColor = Color.black;
    }

    public void setPort(ParallelPort parallelPort) {
        this.counter.setPort(parallelPort);
    }

    public void showValues() {
        this.counter.showValues();
    }

    public void clearValues() {
        this.counter.clearValues();
    }

    public void setBitsPerCharacter(int n) {
        this.counter.setBitsPerCharacter(n);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.first && this.text.getCaretPosition() > 0) {
            this.first = false;
            this.text.replaceRange("", 0, this.text.getCaretPosition() - 1);
        }
        if (!this.first) {
            this.sendData();
        }
    }

    public void run() {
        this.sendData();
    }

    public void sendString(String string) {
        block3: {
            int n = string.length();
            if (n > 0) {
                this.owner.ctlSigs.BE = false;
                try {
                    this.owner.out.write(string.getBytes());
                    this.counter.incrementValue((long)n);
                    this.owner.ctlSigs.showValues();
                    this.owner.ctlSigs.showErrorValues();
                }
                catch (IOException iOException) {
                    if (!this.owner.open) break block3;
                    System.out.println(this.owner.port.getName() + ": Cannot write to output stream");
                    this.auto.setState(false);
                }
            }
        }
    }

    private void sendData() {
        if (this.owner.open && this.auto.getState()) {
            while (this.owner.open && this.auto.getState()) {
                this.sendString(testString);
            }
        } else {
            String string = this.text.getText();
            this.sendString(string);
            this.text.setText("");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.auto.getState() && this.thr == null && this.owner.open) {
            this.auto.setForeground(this.onColor);
            this.startTransmit();
        } else {
            this.stopTransmit();
        }
    }

    private void startTransmit() {
        if (this.owner.open && this.thr == null) {
            this.counter.resetRate();
            this.thr = new Thread((Runnable)this, "Xmt " + this.owner.port.getName());
            this.thr.start();
        }
    }

    public void stopTransmit() {
        this.thr = null;
        this.auto.setState(false);
        this.auto.setForeground(this.offColor);
    }
}

