/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Portmapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEvent;
import javax.comm.ParallelPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SolarisParallel
extends ParallelPort {
    private int port_mode = 1;
    private ParallelPortEventListener listener = null;
    private int rcv_timeout = 0;
    private int rcv_threshold = 0;
    private int framing_byte = -1;
    private int ibuffer_size = 1024;
    private int obuffer_size = 1024;
    private int deviceType = 0;
    public static final int LPT_MODE_ANY = 0;
    public static final int LPT_MODE_SPP = 1;
    public static final int LPT_MODE_PS2 = 2;
    public static final int LPT_MODE_EPP = 3;
    public static final int LPT_MODE_ECP = 4;
    private static final int STATUS_PaperOut = 1;
    private static final int STATUS_PrtBusy = 2;
    private static final int STATUS_PrtSelected = 4;
    private static final int STATUS_PrtTimedOut = 8;
    private static final int STATUS_PrtError = 16;
    private SPInputStream inputStream = null;
    private SPOutputStream outputStream = null;
    private int notificationMask = 0;
    private static final int NOTIFY_ERR = 1;
    private static final int NOTIFY_BUF = 2;
    private int port_fd = 0;

    public SolarisParallel(String theName) throws IOException {
        this.name = theName;
        if (this.port_fd != 0) {
            return;
        }
        String portName = Portmapping.translatePortname(theName);
        if (System.getProperty("portmap_debug") != null) {
            System.err.println("SolarisParallel(" + theName + ") = " + portName);
        }
        try {
            this.port_fd = this.openNativePort(portName);
        }
        catch (IOException e) {
            throw new IOException("  Error opening \"" + portName + "\"\n  " + e.getMessage());
        }
    }

    private int getDeviceType() {
        return this.deviceType;
    }

    private void setDeviceType(int n) {
        this.deviceType = n;
    }

    public int getOutputBufferFree() {
        return 512;
    }

    public int setMode(int mode) throws UnsupportedCommOperationException {
        switch (mode) {
            case 0: {
                this.port_mode = 1;
                break;
            }
            case 1: {
                this.port_mode = 1;
                break;
            }
            case 2: {
                this.port_mode = 2;
                break;
            }
            default: {
                throw new UnsupportedCommOperationException("mode not supported");
            }
        }
        return this.port_mode;
    }

    public int getMode() {
        return this.port_mode;
    }

    public void suspend() {
    }

    public void restart() {
    }

    private native void setNativeTimeout(int var1, int var2);

    public boolean isPaperOut() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 1);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterBusy() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 2);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterSelected() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 4);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterTimedOut() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 8);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterError() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 16);
        }
        throw new IllegalStateException("This port is closed");
    }

    private native boolean getStatusFlags(int var1, int var2);

    public void addEventListener(ParallelPortEventListener lsnr) throws TooManyListenersException {
        if (this.port_fd > 0) {
            if (this.listener != null) {
                throw new TooManyListenersException("only one listener is allowed");
            }
        } else {
            throw new IllegalStateException("This port is closed");
        }
        this.listener = lsnr;
    }

    public void removeEventListener() {
        this.listener = null;
    }

    private void raiseEvent(int notify_bit, boolean oldvalue, boolean newvalue) {
        int eventtype = 0;
        if (this.listener != null && (this.notificationMask & notify_bit) > 0) {
            switch (notify_bit) {
                case 1: {
                    eventtype = 1;
                    break;
                }
                case 2: {
                    eventtype = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            this.listener.parallelEvent(new ParallelPortEvent(this, eventtype, oldvalue, newvalue));
        }
    }

    public void notifyOnError(boolean enable) {
        this.notificationMask &= 0xFFFFFFFE;
        if (enable) {
            this.notificationMask |= 1;
        }
    }

    public void notifyOnBuffer(boolean enable) {
        this.notificationMask &= 0xFFFFFFFD;
        if (enable) {
            this.notificationMask |= 2;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.port_fd > 0) {
            if (this.port_mode == 2) {
                if (this.inputStream == null) {
                    this.inputStream = new SPInputStream();
                }
                return this.inputStream;
            }
            throw new IOException("This port is not in bidirectional mode");
        }
        throw new IllegalStateException("This port is closed");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.port_fd > 0) {
            if (this.outputStream == null) {
                this.outputStream = new SPOutputStream(this);
            }
            return this.outputStream;
        }
        throw new IllegalStateException("This port is closed");
    }

    public void close() {
        try {
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port is closed");
            }
            this.closeNativePort(this.port_fd);
            this.port_fd = 0;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        super.close();
    }

    private native int openNativePort(String var1) throws IOException;

    private native void closeNativePort(int var1) throws IOException;

    private native int available(int var1) throws IOException;

    private native byte readByte(int var1) throws IOException;

    private native int read(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native int write(int var1, byte[] var2, int var3, int var4) throws IOException;

    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (this.port_mode == 2) {
            throw new UnsupportedCommOperationException("Receive threshold is not supported in Solaris parallel port");
        }
        throw new IllegalStateException("This port is not in bidirectional mode");
    }

    public void disableReceiveThreshold() {
        if (this.port_mode != 2) {
            throw new IllegalStateException("This port is not in bidirectional mode");
        }
        this.rcv_threshold = 0;
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public int getReceiveThreshold() {
        return this.rcv_threshold;
    }

    public void enableReceiveTimeout(int rcvTimeout) {
        if (this.port_mode == 2) {
            this.rcv_timeout = rcvTimeout;
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port is closed");
            }
        } else {
            throw new IllegalStateException("The port mode is not bidirectional");
        }
        this.setNativeTimeout(this.port_fd, this.rcv_timeout * 1000);
    }

    public void disableReceiveTimeout() {
        if (this.port_mode == 2) {
            this.rcv_timeout = 0;
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port is closed");
            }
        } else {
            throw new IllegalStateException("The port mode is not bidirectional");
        }
        this.setNativeTimeout(this.port_fd, this.rcv_timeout);
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcv_timeout > 0;
    }

    public int getReceiveTimeout() {
        return this.rcv_timeout;
    }

    public void disableReceiveFraming() {
        if (this.port_mode != 2) {
            throw new IllegalStateException("This port is not in bidirectional mode");
        }
        this.framing_byte = -1;
    }

    public void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
        if (this.port_mode == 2) {
            this.framing_byte = -1;
            throw new UnsupportedCommOperationException("Receive framing is not supported in Solaris parallel port");
        }
        throw new IllegalStateException("This port is not in bidirectional mode");
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return this.framing_byte;
    }

    public void setInputBufferSize(int size) {
        this.ibuffer_size = size;
    }

    public int getInputBufferSize() {
        return this.ibuffer_size;
    }

    public void setOutputBufferSize(int size) {
        this.obuffer_size = size;
    }

    public int getOutputBufferSize() {
        return this.obuffer_size;
    }

    static {
        System.loadLibrary("SolarisSerialParallel");
    }

    public class SPOutputStream
    extends OutputStream {
        private SolarisParallel spPort;

        public SPOutputStream(SolarisParallel port) {
            this.spPort = port;
        }

        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            if (SolarisParallel.this.port_fd > 0) {
                int status = SolarisParallel.this.write(SolarisParallel.this.port_fd, buf, 0, 1);
                if (status != 1) {
                    throw new IOException("write to parallel port failed");
                }
            } else {
                throw new IllegalStateException("This port is closed");
            }
        }

        public void write(byte[] b, int offset, int len) throws IOException {
            int write_up_to = len;
            int status = 0;
            String bs = new String(b);
            if (b != null) {
                if (len + offset > b.length) {
                    write_up_to = b.length - offset;
                }
                if (SolarisParallel.this.port_fd > 0) {
                    status = this.spPort.write(SolarisParallel.this.port_fd, b, offset, write_up_to);
                    if (status != write_up_to) {
                        throw new IOException("write to parallel port failed");
                    }
                } else {
                    throw new IllegalStateException("Port Closed");
                }
            }
        }
    }

    public class SPInputStream
    extends InputStream {
        private byte[] buf = null;
        private int pos = -1;
        private int high = 0;

        public int available() throws IOException {
            if (SolarisParallel.this.port_fd != 0) {
                return SolarisParallel.this.available(SolarisParallel.this.port_fd);
            }
            throw new IllegalStateException("This port is closed");
        }

        public int read(byte[] b, int offset, int len) throws IOException {
            int read_up_to = len;
            int status = 0;
            if (b == null) {
                b = new byte[len + offset];
            }
            if (len + offset > b.length) {
                read_up_to = b.length - offset;
            }
            try {
                if (SolarisParallel.this.port_fd <= 0) {
                    throw new IllegalStateException("Port Closed");
                }
                status = SolarisParallel.this.read(SolarisParallel.this.port_fd, b, offset, read_up_to);
                return status;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
        }

        public int read() throws IOException {
            if (SolarisParallel.this.port_fd > 0) {
                return SolarisParallel.this.readByte(SolarisParallel.this.port_fd);
            }
            throw new IllegalStateException("This port is closed");
        }

        void printbuf(byte[] buf) {
            String s = new String();
            for (int i = 0; i < buf.length; ++i) {
                s = s + Integer.toHexString(buf[i]) + " ";
            }
            System.out.println("\nhigh = " + this.high + "IN: " + s);
        }
    }
}

