/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimplePropertyNamespaceHandler
implements NamespaceHandler {
    private static final String REF_SUFFIX = "-ref";

    public void init() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        parserContext.getReaderContext().error("Class [" + this.getClass().getName() + "] does not support custom elements.", element);
        return null;
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder beanDefinitionHolder, ParserContext parserContext) {
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            String string = attr.getLocalName();
            String string2 = attr.getValue();
            MutablePropertyValues mutablePropertyValues = beanDefinitionHolder.getBeanDefinition().getPropertyValues();
            if (mutablePropertyValues.contains(string)) {
                parserContext.getReaderContext().error("Property '" + string + "' is already defined using " + "both <property> and inline syntax. Only one approach may be used per property.", attr);
            }
            if (string.endsWith(REF_SUFFIX)) {
                string = string.substring(0, string.length() - REF_SUFFIX.length());
                mutablePropertyValues.addPropertyValue(Conventions.attributeNameToPropertyName((String)string), new RuntimeBeanReference(string2));
            } else {
                mutablePropertyValues.addPropertyValue(Conventions.attributeNameToPropertyName((String)string), string2);
            }
        }
        return beanDefinitionHolder;
    }
}

