/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.NumberFormat;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class CustomNumberEditor
extends PropertyEditorSupport {
    private final Class numberClass;
    private final NumberFormat numberFormat;
    private final boolean allowEmpty;
    static /* synthetic */ Class class$java$lang$Number;

    public CustomNumberEditor(Class clazz, boolean bl) throws IllegalArgumentException {
        this(clazz, null, bl);
    }

    public CustomNumberEditor(Class clazz, NumberFormat numberFormat, boolean bl) throws IllegalArgumentException {
        if (clazz == null || !(class$java$lang$Number == null ? (class$java$lang$Number = CustomNumberEditor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = clazz;
        this.numberFormat = numberFormat;
        this.allowEmpty = bl;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)string)) {
            this.setValue(null);
        } else if (this.numberFormat != null) {
            this.setValue(NumberUtils.parseNumber((String)string, (Class)this.numberClass, (NumberFormat)this.numberFormat));
        } else {
            this.setValue(NumberUtils.parseNumber((String)string, (Class)this.numberClass));
        }
    }

    public void setValue(Object object) {
        if (object instanceof Number) {
            super.setValue(NumberUtils.convertNumberToTargetClass((Number)((Number)object), (Class)this.numberClass));
        } else {
            super.setValue(object);
        }
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "";
        }
        if (this.numberFormat != null) {
            return this.numberFormat.format(object);
        }
        return object.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

