/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextArea;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialConnection
implements SerialPortEventListener,
CommPortOwnershipListener {
    private SerialDemo parent;
    private TextArea messageAreaOut;
    private TextArea messageAreaIn;
    private SerialParameters parameters;
    private OutputStream os;
    private InputStream is;
    private KeyHandler keyHandler;
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean open;

    public SerialConnection(SerialDemo serialDemo, SerialParameters serialParameters, TextArea textArea, TextArea textArea2) {
        this.parent = serialDemo;
        this.parameters = serialParameters;
        this.messageAreaOut = textArea;
        this.messageAreaIn = textArea2;
        this.open = false;
    }

    public void openConnection() throws SerialConnectionException {
        try {
            this.portId = CommPortIdentifier.getPortIdentifier(this.parameters.getPortName());
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new SerialConnectionException(noSuchPortException.getMessage());
        }
        try {
            this.sPort = (SerialPort)this.portId.open("SerialDemo", 30000);
        }
        catch (PortInUseException portInUseException) {
            throw new SerialConnectionException(portInUseException.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (SerialConnectionException serialConnectionException) {
            this.sPort.close();
            throw serialConnectionException;
        }
        try {
            this.os = this.sPort.getOutputStream();
            this.is = this.sPort.getInputStream();
        }
        catch (IOException iOException) {
            this.sPort.close();
            throw new SerialConnectionException("Error opening i/o streams");
        }
        this.keyHandler = new KeyHandler(this, this.os);
        this.messageAreaOut.addKeyListener((KeyListener)this.keyHandler);
        try {
            this.sPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
        this.sPort.notifyOnBreakInterrupt(true);
        try {
            this.sPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.portId.addPortOwnershipListener((CommPortOwnershipListener)this);
        this.open = true;
    }

    public void setConnectionParameters() throws SerialConnectionException {
        int n = this.sPort.getBaudRate();
        int n2 = this.sPort.getDataBits();
        int n3 = this.sPort.getStopBits();
        int n4 = this.sPort.getParity();
        int n5 = this.sPort.getFlowControlMode();
        try {
            this.sPort.setSerialPortParams(this.parameters.getBaudRate(), this.parameters.getDatabits(), this.parameters.getStopbits(), this.parameters.getParity());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.parameters.setBaudRate(n);
            this.parameters.setDatabits(n2);
            this.parameters.setStopbits(n3);
            this.parameters.setParity(n4);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(this.parameters.getFlowControlIn() | this.parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new SerialConnectionException("Unsupported flow control");
        }
    }

    public void closeConnection() {
        if (!this.open) {
            return;
        }
        this.messageAreaOut.removeKeyListener((KeyListener)this.keyHandler);
        if (this.sPort != null) {
            try {
                this.os.close();
                this.is.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            this.sPort.close();
            this.portId.removePortOwnershipListener((CommPortOwnershipListener)this);
        }
        this.open = false;
    }

    public void sendBreak() {
        this.sPort.sendBreak(1000);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        switch (serialPortEvent.getEventType()) {
            case 1: {
                while (n != -1) {
                    try {
                        n = this.is.read();
                        if (n == -1) break;
                        if ('\r' == (char)n) {
                            stringBuffer.append('\n');
                            continue;
                        }
                        stringBuffer.append((char)n);
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                        return;
                    }
                }
                this.messageAreaIn.append(new String(stringBuffer));
                break;
            }
            case 10: {
                this.messageAreaIn.append("\n--- BREAK RECEIVED ---\n");
            }
        }
    }

    public void ownershipChange(int n) {
        if (n == 3) {
            PortRequestedDialog portRequestedDialog = new PortRequestedDialog(this.parent);
        }
    }
}

