/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public abstract class PropertiesLoaderSupport {
    public static final String XML_FILE_EXTENSION = ".xml";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties[] localProperties;
    private Resource[] locations;
    private boolean localOverride = false;
    private boolean ignoreResourceNotFound = false;
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public void setProperties(Properties properties) {
        this.localProperties = new Properties[]{properties};
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        this.localProperties = propertiesArray;
    }

    public void setLocation(Resource resource) {
        this.locations = new Resource[]{resource};
    }

    public void setLocations(Resource[] resourceArray) {
        this.locations = resourceArray;
    }

    public void setLocalOverride(boolean bl) {
        this.localOverride = bl;
    }

    public void setIgnoreResourceNotFound(boolean bl) {
        this.ignoreResourceNotFound = bl;
    }

    public void setFileEncoding(String string) {
        this.fileEncoding = string;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties = new Properties();
        if (this.localOverride) {
            this.loadProperties(properties);
        }
        if (this.localProperties != null) {
            for (int i = 0; i < this.localProperties.length; ++i) {
                CollectionUtils.mergePropertiesIntoMap(this.localProperties[i], properties);
            }
        }
        if (!this.localOverride) {
            this.loadProperties(properties);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(Properties properties) throws IOException {
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                Resource resource = this.locations[i];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading properties file from " + resource));
                }
                InputStream inputStream = null;
                try {
                    inputStream = resource.getInputStream();
                    if (resource.getFilename().endsWith(XML_FILE_EXTENSION)) {
                        this.propertiesPersister.loadFromXml(properties, inputStream);
                        continue;
                    }
                    if (this.fileEncoding != null) {
                        this.propertiesPersister.load(properties, new InputStreamReader(inputStream, this.fileEncoding));
                        continue;
                    }
                    this.propertiesPersister.load(properties, inputStream);
                    continue;
                }
                catch (IOException iOException) {
                    if (this.ignoreResourceNotFound) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("Could not load properties from " + resource + ": " + iOException.getMessage()));
                        continue;
                    }
                    throw iOException;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
    }
}

