/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class Log4jConfigurer {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String XML_FILE_EXTENSION = ".xml";

    public static void initLogging(String string) throws FileNotFoundException {
        String string2 = SystemPropertyUtils.resolvePlaceholders(string);
        URL uRL = ResourceUtils.getURL(string2);
        if (string2.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configure((URL)uRL);
        } else {
            PropertyConfigurator.configure((URL)uRL);
        }
    }

    public static void initLogging(String string, long l) throws FileNotFoundException {
        String string2 = SystemPropertyUtils.resolvePlaceholders(string);
        File file = ResourceUtils.getFile(string2);
        if (!file.exists()) {
            throw new FileNotFoundException("Log4J config file [" + string2 + "] not found");
        }
        if (string2.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configureAndWatch((String)file.getAbsolutePath(), (long)l);
        } else {
            PropertyConfigurator.configureAndWatch((String)file.getAbsolutePath(), (long)l);
        }
    }

    public static void shutdownLogging() {
        LogManager.shutdown();
    }

    public static void setWorkingDirSystemProperty(String string) {
        System.setProperty(string, new File("").getAbsolutePath());
    }
}

