/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.processor;

import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import org.apache.log4j.Logger;

class WorkMonitor
extends Thread {
    private static Logger logger = Logger.getLogger(WorkMonitor.class);
    private AbstractProcessor processer;

    public WorkMonitor(AbstractProcessor processer) {
        this.processer = processer;
    }

    @Override
    public void run() {
        int count = 0;
        while (!SystemEnv.stopping && !this.processer.isClosing() && this.processer.getHandler() != null) {
            try {
                if (count == 0) {
                    this.processer.pollQuery();
                } else {
                    WorkMonitor.sleep(1000L);
                    if (this.processer.isfirstquery) {
                        count = GlobalVariables.globalConfig.getPageRefreshInterval();
                    }
                }
                ++count;
                int maxwait = GlobalVariables.globalConfig.getDataRecordInterval();
                if (this.getPriority() == 10) {
                    maxwait = GlobalVariables.globalConfig.getPageRefreshInterval();
                }
                if (count >= maxwait) {
                    count = 0;
                }
                if (GlobalProcessors.findProcessor(this.processer.processorKey()) != null) continue;
                logger.error((Object)"WorkMonitor close");
                this.processer.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

