/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

public class SerialPortDisplay
extends Panel
implements SerialPortEventListener,
MouseListener,
CommPortOwnershipListener {
    protected CommPortIdentifier portID;
    protected SerialPort port = null;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream outSave;
    protected boolean lineMonitor;
    protected boolean silentReceive;
    protected boolean modemMode;
    protected boolean open = false;
    protected int numDataBits = 1;
    private int rcvDelay;
    private Thread rcvThread = null;
    private BlackBox owner;
    private boolean threadRcv;
    private boolean friendly;
    private boolean waiting = false;
    Panel display;
    Panel statePanel;
    Panel textPanel;
    Label portName = null;
    BaudRate baudRate;
    DataBits dataBits;
    Parity parity;
    StopBits stopBits;
    CtlSigDisplay ctlSigs;
    FlowCtlDisplay flowCtl;
    Receiver receiver;
    Transmitter transmitter;

    public SerialPortDisplay(CommPortIdentifier commPortIdentifier, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, BlackBox blackBox) throws PortInUseException {
        this.setLayout((LayoutManager)new BorderLayout());
        this.owner = blackBox;
        this.lineMonitor = false;
        this.outSave = null;
        this.portID = commPortIdentifier;
        this.threadRcv = bl;
        this.friendly = bl2;
        this.rcvDelay = n;
        this.silentReceive = bl3;
        this.modemMode = bl4;
        this.openBBPort();
    }

    private boolean openBBPort() throws PortInUseException {
        if (this.open) {
            this.closeBBPort();
        }
        this.portID.addPortOwnershipListener((CommPortOwnershipListener)this);
        try {
            this.port = (SerialPort)this.portID.open("BlackBox", 2000);
            if (this.port == null) {
                System.out.println("Error opening port " + this.portID.getName());
                return false;
            }
            this.open = true;
            this.waiting = false;
            if (this.portName != null) {
                this.portName.setForeground(Color.green);
            }
            try {
                this.in = this.port.getInputStream();
            }
            catch (IOException iOException) {
                System.out.println("Cannot open input stream");
            }
            try {
                this.out = this.modemMode ? new ConvertedOutputStream(this.port.getOutputStream()) : this.port.getOutputStream();
            }
            catch (IOException iOException) {
                System.out.println("Cannot open output stream");
            }
            this.createPanel();
            this.showValues();
            try {
                this.port.addEventListener((SerialPortEventListener)this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
            this.port.notifyOnCTS(true);
            this.port.notifyOnDSR(true);
            this.port.notifyOnRingIndicator(true);
            this.port.notifyOnCarrierDetect(true);
            this.port.notifyOnOverrunError(true);
            this.port.notifyOnParityError(true);
            this.port.notifyOnFramingError(true);
            this.port.notifyOnBreakInterrupt(true);
            this.port.notifyOnDataAvailable(true);
            this.port.notifyOnOutputEmpty(true);
            if (this.threadRcv && this.rcvThread == null) {
                this.rcvThread = new Thread((Runnable)this.receiver, "Rcv " + this.port.getName());
                this.rcvThread.start();
            } else {
                this.rcvThread = null;
            }
        }
        catch (PortInUseException portInUseException) {
            System.out.println("Queueing open for " + this.portID.getName() + ": port in use by " + portInUseException.currentOwner);
            if (this.portName != null) {
                this.portName.setForeground(Color.yellow);
            }
            this.waiting = true;
        }
        return true;
    }

    public void closeBBPort() {
        if (this.open) {
            System.out.println("Closing " + this.port.getName());
            this.portName.setForeground(Color.red);
            this.open = false;
            this.transmitter.stopTransmit();
            if (this.rcvThread != null) {
                this.rcvThread.interrupt();
                this.rcvThread = null;
            }
            this.port.removeEventListener();
            this.portID.removePortOwnershipListener((CommPortOwnershipListener)this);
            this.port.close();
            this.port = null;
            this.ctlSigs.setPort(this.port);
            this.flowCtl.setPort(this.port);
            this.receiver.setPort(this.port);
            this.transmitter.setPort(this.port);
            this.transmitter.clearValues();
            this.receiver.clearValues();
            this.flowCtl.clearValues();
            this.ctlSigs.clearValues();
            this.ctlSigs.clearErrorValues();
            this.showValues();
        }
    }

    public SerialPort getPort() {
        return this.open ? this.port : null;
    }

    private OutputStream getOutputStream() {
        return this.out;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outSave = this.getOutputStream();
        this.out = outputStream;
    }

    public void setLineMonitor(SerialPortDisplay serialPortDisplay, boolean bl) {
        this.lineMonitor = bl;
        serialPortDisplay.lineMonitor = bl;
        if (this.lineMonitor) {
            this.setOutputStream(serialPortDisplay.getOutputStream());
            serialPortDisplay.setOutputStream(this.outSave);
        } else {
            serialPortDisplay.setOutputStream(this.getOutputStream());
            this.setOutputStream(this.outSave);
        }
    }

    private void createPanel() {
        if (this.portName != null) {
            this.ctlSigs.setPort(this.port);
            this.flowCtl.setPort(this.port);
            this.receiver.setPort(this.port);
            this.transmitter.setPort(this.port);
        } else {
            this.display = new Panel();
            this.display.setLayout(new FlowLayout());
            this.portName = new Label(this.portID.getName());
            if (this.open) {
                this.portName.setForeground(Color.green);
            } else if (this.waiting) {
                this.portName.setForeground(Color.yellow);
            } else {
                this.portName.setForeground(Color.red);
            }
            this.portName.addMouseListener((MouseListener)this);
            this.display.add(this.portName);
            this.baudRate = new BaudRate(this);
            this.display.add((Component)this.baudRate);
            this.dataBits = new DataBits(this);
            this.display.add((Component)this.dataBits);
            this.stopBits = new StopBits(this);
            this.display.add((Component)this.stopBits);
            this.parity = new Parity(this);
            this.display.add((Component)this.parity);
            this.add("North", (Component)this.display);
            this.statePanel = new Panel();
            this.statePanel.setLayout(new BorderLayout());
            this.ctlSigs = new CtlSigDisplay(this.port);
            this.statePanel.add("North", (Component)this.ctlSigs);
            this.flowCtl = new FlowCtlDisplay(this.port);
            this.statePanel.add("South", (Component)this.flowCtl);
            this.add("South", (Component)this.statePanel);
            this.textPanel = new Panel();
            this.textPanel.setLayout(new BorderLayout());
            this.receiver = new Receiver(this, 6, 40, this.rcvDelay, this.silentReceive);
            this.textPanel.add("East", (Component)this.receiver);
            this.transmitter = new Transmitter(this, 6, 40, this.modemMode);
            this.textPanel.add("West", (Component)this.transmitter);
            this.add("Center", (Component)this.textPanel);
            this.owner.addPanel(this);
        }
    }

    protected void showValues() {
        this.baudRate.showValue();
        this.dataBits.showValue();
        this.stopBits.showValue();
        this.parity.showValue();
        this.transmitter.setBitsPerCharacter(this.numDataBits);
        this.receiver.setBitsPerCharacter(this.numDataBits);
        this.transmitter.showValues();
        this.receiver.showValues();
        this.flowCtl.showValues();
        this.ctlSigs.showValues();
        this.ctlSigs.showErrorValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        if (this.port == null) {
            System.out.println(this.port.getName() + "got serial event on a closed port");
            return;
        }
        switch (serialPortEvent.getEventType()) {
            case 10: {
                this.ctlSigs.BILabel.setState(serialPortEvent.getNewValue());
                break;
            }
            case 7: {
                this.ctlSigs.OELabel.setState(serialPortEvent.getNewValue());
                break;
            }
            case 9: {
                this.ctlSigs.FELabel.setState(serialPortEvent.getNewValue());
                break;
            }
            case 8: {
                this.ctlSigs.PELabel.setState(serialPortEvent.getNewValue());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.ctlSigs.showValues();
                break;
            }
            case 1: {
                this.ctlSigs.DA = true;
                this.ctlSigs.showErrorValues();
                if (this.rcvThread != null) {
                    Receiver receiver = this.receiver;
                    synchronized (receiver) {
                        this.receiver.notify();
                        break;
                    }
                }
                if (this.threadRcv) {
                    System.out.println(this.port.getName() + "Receive thread has died!");
                    this.rcvThread = new Thread((Runnable)this.receiver, "Rcv " + this.port.getName());
                    this.rcvThread.start();
                    break;
                }
                this.receiver.readData();
                break;
            }
            case 2: {
                this.ctlSigs.BE = true;
                this.ctlSigs.showErrorValues();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.open) {
            this.closeBBPort();
        } else {
            try {
                this.openBBPort();
            }
            catch (PortInUseException portInUseException) {
                System.out.println(this.portID.getName() + " is in use by " + portInUseException.currentOwner);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void ownershipChange(int n) {
        switch (n) {
            case 2: {
                System.out.println(this.portID.getName() + ": PORT_UNOWNED");
                if (!this.waiting) break;
                try {
                    this.openBBPort();
                }
                catch (PortInUseException portInUseException) {
                    System.out.println(this.portID.getName() + " s/b free but is in use by " + portInUseException.currentOwner);
                }
                break;
            }
            case 1: {
                System.out.println(this.portID.getName() + ": PORT_OWNED [by this application]");
                break;
            }
            case 3: {
                System.out.println(this.portID.getName() + ": PORT_OWNERSHIP_REQUESTED [by this application]");
                if (!this.friendly || !this.open) break;
                this.closeBBPort();
            }
        }
    }
}

