/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Alias;
import com.sun.comm.PathBundle;
import com.sun.comm.PortmapDatabase;
import com.sun.comm.SunrayInfo;
import com.sun.comm.Unix;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;

class PortmapEntry {
    private String logicalName = null;
    private String equatedName = null;
    private String terminalId = null;
    private String dtuName = null;
    private Alias alnAlias = null;
    private String alnPath = null;
    private int alnPortType = 0;
    private boolean dtuAlias;
    private boolean assignedToDTU;
    private boolean dtuSpecificALN;
    private boolean sessionLocalALN;
    private boolean sessionIndependent;
    private boolean hidingAlias;
    private boolean globallyVisible;

    PortmapEntry(String line) throws IOException {
        Enumeration e;
        StringTokenizer st;
        String op = null;
        int i = line.indexOf(35);
        if (i != -1) {
            line = line.substring(0, i);
        }
        if (line.indexOf(61) == -1) {
            st = new StringTokenizer(line, " \t");
            if (st.hasMoreTokens()) {
                this.logicalName = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                op = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.equatedName = st.nextToken();
            }
        } else {
            StringBuffer sb = new StringBuffer(line);
            op = "=";
            while ((i = sb.toString().indexOf(" ")) > 0 || (i = sb.toString().indexOf("\t")) > 0) {
                sb.deleteCharAt(i);
            }
            st = new StringTokenizer(sb.toString(), "=");
            this.logicalName = st.nextToken();
            if (st.hasMoreTokens()) {
                this.equatedName = st.nextToken();
            }
        }
        if (!this.logicalName.equals("[hide]")) {
            e = PortmapDatabase.elements();
            while (e.hasMoreElements()) {
                PortmapEntry pme = (PortmapEntry)e.nextElement();
                if (!pme.getLogicalName().equals(this.logicalName)) continue;
                throw new IOException("Duplicate definition enountered");
            }
        } else {
            this.equatedName = op;
            op = "=";
        }
        if (op.equals("=")) {
            Alias alias = new Alias(this.equatedName);
            if (PortmapEntry.isTerminalId(this.equatedName)) {
                this.dtuAlias = true;
                this.dtuName = this.logicalName;
                this.terminalId = PortmapEntry.formatTerminalId(this.equatedName);
                if (!SunrayInfo.isDTUonline(this.terminalId)) {
                    throw new IOException("DTU not found");
                }
                e = PortmapDatabase.elements();
                while (e.hasMoreElements()) {
                    PortmapEntry pme = (PortmapEntry)e.nextElement();
                    if (!pme.getDTUterminalId().equals(this.terminalId)) continue;
                    throw new IOException("Duplicate DTU alias enountered");
                }
                return;
            }
            if (this.equatedName.indexOf(58) != -1) {
                int cp = this.equatedName.indexOf(58);
                alias = new Alias(this.equatedName.substring(cp + 1));
                if (alias.matchesWildcard("utcom") || alias.matchesWildcard("utprt")) {
                    this.dtuSpecificALN = true;
                    st = new StringTokenizer(this.equatedName, ":");
                    this.dtuName = st.nextToken();
                    this.equatedName = st.nextToken();
                    String termId = PortmapDatabase.DTUnameToTerminalId(this.dtuName);
                    if (termId != null) {
                        alias = new Alias(this.equatedName);
                        if (alias.matchesWildcard("utcom")) {
                            this.alnAlias = alias;
                            this.alnPortType = 1;
                            this.alnPath = this.getDonglePortPath(this.alnAlias, this.alnPortType, termId);
                            return;
                        }
                        if (alias.matchesWildcard("utprt")) {
                            this.alnAlias = alias;
                            this.alnPortType = 2;
                            this.alnPath = this.getDonglePortPath(this.alnAlias, this.alnPortType, termId);
                            return;
                        }
                    } else {
                        throw new IOException("Couldn't locate referenced DTU");
                    }
                    throw new IOException("Couldn't resolve ALN");
                }
                this.dtuName = this.equatedName.substring(0, cp);
                String path = this.equatedName.substring(cp + 1);
                if (this.dtuName.equals("*") && Unix.isDevLink(path)) {
                    this.globallyVisible = true;
                    this.equatedName = path;
                    return;
                }
                this.terminalId = PortmapDatabase.DTUnameToTerminalId(this.dtuName);
                if (this.terminalId != null && Unix.isDevLink(path)) {
                    this.equatedName = path;
                    this.assignedToDTU = true;
                    return;
                }
            } else {
                if (alias.matchesWildcard("utcom")) {
                    if (!SunrayInfo.isSessionActive()) {
                        throw new IOException();
                    }
                    this.sessionLocalALN = true;
                    this.alnAlias = alias;
                    this.alnPortType = 1;
                    this.alnPath = this.getDonglePortPath(this.alnAlias, this.alnPortType, null);
                    return;
                }
                if (alias.matchesWildcard("utprt")) {
                    if (!SunrayInfo.isSessionActive()) {
                        throw new IOException();
                    }
                    this.sessionLocalALN = true;
                    this.alnAlias = alias;
                    this.alnPortType = 2;
                    this.alnPath = this.getDonglePortPath(this.alnAlias, this.alnPortType, null);
                    return;
                }
                this.sessionIndependent = true;
                if (this.logicalName.equals("[hide]")) {
                    this.hidingAlias = true;
                }
                return;
            }
        }
        throw new IOException("Bad syntax or undefined DTU alias encountered");
    }

    private String getDonglePortPath(Alias alnAlias, int type, String termId) throws IOException {
        String devRoot = termId == null ? SunrayInfo.getSessionDevRoot() : SunrayInfo.getDTUdevRoot(termId);
        String relDir = type == 1 ? "/dev/term" : "/dev/printers";
        int portIdx = alnAlias.getUnitNbr() - 1;
        if (portIdx < 0) {
            throw new IOException("Unit Nbr. out of range");
        }
        PathBundle donglePorts = new PathBundle();
        donglePorts.add(devRoot + relDir, type);
        PathBundle[] portList = donglePorts.getAll();
        if (portIdx >= donglePorts.getCount()) {
            throw new IOException("Port not found on USB/RS-232 adapter dongle");
        }
        return portList[portIdx].getPath();
    }

    PortmapEntry(String logicalName, String equatedName) {
        this.logicalName = logicalName;
        this.equatedName = equatedName;
        PortmapDatabase.add(this);
    }

    public Alias toAlias() {
        return new Alias(this.logicalName);
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getEquatedTarget() {
        return this.equatedName;
    }

    public String getDTUterminalId() {
        return this.terminalId;
    }

    public String getDTUname() {
        return this.dtuName;
    }

    public Alias getALNalias() {
        return this.alnAlias;
    }

    public int getALNportType() {
        return this.alnPortType;
    }

    public String getALNpath() {
        return this.alnPath;
    }

    private static boolean isTerminalId(String hypothetical) {
        String tmp = "";
        if (hypothetical.startsWith("IEEE802.")) {
            tmp = hypothetical.substring(8).toLowerCase();
        } else {
            String s = "";
            StringTokenizer st = new StringTokenizer(hypothetical, ":");
            while (st.hasMoreTokens()) {
                tmp = tmp + st.nextToken();
            }
        }
        int len = tmp.length();
        if (len != 12) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if ("0123456789abcdef".indexOf(tmp.substring(i, i + 1)) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean isDTUalias() {
        return this.dtuAlias;
    }

    public boolean isAssignedToDTU() {
        return this.assignedToDTU;
    }

    public boolean isSessionIndependent() {
        return this.sessionIndependent;
    }

    public boolean isHidden() {
        return this.hidingAlias;
    }

    public boolean isSessionLocalALN() {
        return this.sessionLocalALN;
    }

    public boolean isGloballyVisible() {
        return this.globallyVisible;
    }

    public boolean isDTUspecificALN() {
        return this.dtuSpecificALN;
    }

    private static String formatTerminalId(String rawTermId) {
        String mac = "";
        if (!PortmapEntry.isTerminalId(rawTermId)) {
            return null;
        }
        if ((rawTermId = rawTermId.toLowerCase()).startsWith("ieee802.")) {
            rawTermId = rawTermId.substring(8);
        }
        boolean tokenCount = false;
        StringTokenizer st = new StringTokenizer(rawTermId, ":");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() < 2) {
                t = "0" + t;
            }
            mac = mac + t;
        }
        return "IEEE802." + mac;
    }

    public String toString() {
        String s = "";
        s = s + "PortmapEntry: " + this.logicalName + " = ";
        if (this.assignedToDTU) {
            s = s + this.equatedName + "  (DTU assigned " + this.dtuName + "{" + this.terminalId + "})";
        } else if (this.globallyVisible) {
            s = s + this.globallyVisible + "  (Globally visible to all DTUs)";
        } else if (this.sessionIndependent) {
            s = s + this.equatedName + "  (Session Independent)";
        } else if (this.dtuAlias) {
            s = s + this.terminalId + "  (DTU alias)";
        } else if (this.dtuSpecificALN) {
            s = s + this.equatedName + "  (ALN specific to \"" + this.dtuName + " =" + this.alnPath + "\")";
        } else if (this.sessionLocalALN) {
            s = s + this.equatedName + "  (Session Local ALN = " + this.alnPath + ")";
        }
        s = s + "\n";
        return s;
    }
}

