/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.SolarisParallel;
import com.sun.comm.SolarisSerial;
import java.io.IOException;
import javax.comm.CommDriver;
import javax.comm.CommPort;

public class SolarisDriver
implements CommDriver {
    private boolean driverInitialized = false;

    public void initialize() {
        if (!this.driverInitialized) {
            try {
                System.loadLibrary("SolarisSerialParallel");
            }
            catch (SecurityException ex1) {
                System.err.println("Security Exception SolarisSerial: " + ex1);
            }
            catch (UnsatisfiedLinkError ex2) {
                System.err.println("Error loading SolarisSerial: " + ex2);
            }
        }
    }

    public CommPort getCommPort(String portName, int portType) {
        CommPort port = null;
        try {
            switch (portType) {
                case 1: {
                    port = new SolarisSerial(portName);
                    break;
                }
                case 2: {
                    port = new SolarisParallel(portName);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\n" + e.getMessage());
        }
        return port;
    }
}

