/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    private final Map attributes = new HashMap();

    public void setAttribute(String string, Object object) {
        Assert.notNull(string, "Name must not be null");
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.removeAttribute(string);
        }
    }

    public Object getAttribute(String string) {
        Assert.notNull(string, "Name must not be null");
        return this.attributes.get(string);
    }

    public Object removeAttribute(String string) {
        Assert.notNull(string, "Name must not be null");
        return this.attributes.remove(string);
    }

    public boolean hasAttribute(String string) {
        Assert.notNull(string, "Name must not be null");
        return this.attributes.containsKey(string);
    }

    public String[] attributeNames() {
        Set set = this.attributes.keySet();
        return set.toArray(new String[set.size()]);
    }

    protected void copyAttributesFrom(AttributeAccessor attributeAccessor) {
        Assert.notNull(attributeAccessor, "Source must not be null");
        String[] stringArray = attributeAccessor.attributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.setAttribute(string, attributeAccessor.getAttribute(string));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AttributeAccessorSupport)) {
            return false;
        }
        AttributeAccessorSupport attributeAccessorSupport = (AttributeAccessorSupport)object;
        return ((Object)this.attributes).equals(attributeAccessorSupport.attributes);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }
}

