/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.Assert;

public abstract class AbstractLabeledEnum
implements LabeledEnum {
    protected AbstractLabeledEnum() {
    }

    public Class getType() {
        return this.getClass();
    }

    public abstract Comparable getCode();

    public abstract String getLabel();

    public int compareTo(Object object) {
        Assert.isTrue(object instanceof AbstractLabeledEnum, "You may only compare LabeledEnums");
        LabeledEnum labeledEnum = (LabeledEnum)object;
        Assert.isTrue(this.getType().equals(labeledEnum.getType()), "You may only compare LabeledEnums of the same type");
        return this.getCode().compareTo(labeledEnum.getCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LabeledEnum)) {
            return false;
        }
        LabeledEnum labeledEnum = (LabeledEnum)object;
        return this.getType().equals(labeledEnum.getType()) && this.getCode().equals(labeledEnum.getCode());
    }

    public int hashCode() {
        return this.getType().hashCode() * 29 + this.getCode().hashCode();
    }

    public String toString() {
        return this.getLabel();
    }
}

