/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class UrlResource
extends AbstractResource {
    private final URL url;
    private final URL cleanedUrl;

    public UrlResource(URL uRL) {
        Assert.notNull(uRL, "URL must not be null");
        this.url = uRL;
        this.cleanedUrl = this.getCleanedUrl(this.url, uRL.toString());
    }

    public UrlResource(String string) throws MalformedURLException {
        Assert.notNull(string, "Path must not be null");
        this.url = new URL(string);
        this.cleanedUrl = this.getCleanedUrl(this.url, string);
    }

    private URL getCleanedUrl(URL uRL, String string) {
        try {
            return new URL(StringUtils.cleanPath(string));
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    public InputStream getInputStream() throws IOException {
        URLConnection uRLConnection = this.url.openConnection();
        uRLConnection.setUseCaches(false);
        return uRLConnection.getInputStream();
    }

    public URL getURL() throws IOException {
        return this.url;
    }

    public File getFile() throws IOException {
        return ResourceUtils.getFile(this.url, this.getDescription());
    }

    public Resource createRelative(String string) throws MalformedURLException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return new UrlResource(new URL(this.url, string));
    }

    public String getFilename() {
        return new File(this.url.getFile()).getName();
    }

    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    public boolean equals(Object object) {
        return object == this || object instanceof UrlResource && this.cleanedUrl.equals(((UrlResource)object).cleanedUrl);
    }

    public int hashCode() {
        return this.cleanedUrl.hashCode();
    }
}

