/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import org.springframework.util.Assert;

public abstract class ReflectionUtils {
    public static FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        public boolean matches(Field field) {
            return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public static void handleReflectionException(Exception exception) {
        if (exception instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + exception.getMessage());
        }
        if (exception instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + exception.getMessage());
        }
        if (exception instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)exception);
        }
        throw new IllegalStateException("Unexpected reflection exception - " + exception.getClass().getName() + ": " + exception.getMessage());
    }

    public static void handleInvocationTargetException(InvocationTargetException invocationTargetException) {
        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        if (invocationTargetException.getTargetException() instanceof Error) {
            throw (Error)invocationTargetException.getTargetException();
        }
        throw new IllegalStateException("Unexpected exception thrown by method - " + invocationTargetException.getTargetException().getClass().getName() + ": " + invocationTargetException.getTargetException().getMessage());
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Assert.notNull(clazz, "'type' cannot be null.");
        Assert.notNull(string, "'name' cannot be null.");
        for (Class clazz2 = clazz; !(class$java$lang$Object == null ? ReflectionUtils.class$("java.lang.Object") : class$java$lang$Object).equals(clazz2) && clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray = clazz2.isInterface() ? clazz2.getMethods() : clazz2.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!string.equals(method.getName()) || !Arrays.equals(classArray, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object object) {
        return ReflectionUtils.invokeMethod(method, object, null);
    }

    public static Object invokeMethod(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReflectionUtils.handleReflectionException(illegalAccessException);
            throw new IllegalStateException("Unexpected reflection exception - " + illegalAccessException.getClass().getName() + ": " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            ReflectionUtils.handleReflectionException(invocationTargetException);
            throw new IllegalStateException("Unexpected reflection exception - " + invocationTargetException.getClass().getName() + ": " + invocationTargetException.getMessage());
        }
    }

    public static boolean isPublicStaticFinal(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n) && Modifier.isFinal(n);
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void doWithMethods(Class clazz, MethodCallback methodCallback) throws IllegalArgumentException {
        ReflectionUtils.doWithMethods(clazz, methodCallback, null);
    }

    public static void doWithMethods(Class clazz, MethodCallback methodCallback, MethodFilter methodFilter) throws IllegalArgumentException {
        do {
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodFilter != null && !methodFilter.matches(methodArray[i])) continue;
                try {
                    methodCallback.doWith(methodArray[i]);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + methodArray[i].getName() + "': " + illegalAccessException);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    public static Method[] getAllDeclaredMethods(Class clazz) throws IllegalArgumentException {
        final LinkedList linkedList = new LinkedList();
        ReflectionUtils.doWithMethods(clazz, new MethodCallback(){

            public void doWith(Method method) {
                linkedList.add(method);
            }
        });
        return linkedList.toArray(new Method[linkedList.size()]);
    }

    public static void doWithFields(Class clazz, FieldCallback fieldCallback) throws IllegalArgumentException {
        ReflectionUtils.doWithFields(clazz, fieldCallback, null);
    }

    public static void doWithFields(Class clazz, FieldCallback fieldCallback, FieldFilter fieldFilter) throws IllegalArgumentException {
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldFilter != null && !fieldFilter.matches(fieldArray[i])) continue;
                try {
                    fieldCallback.doWith(fieldArray[i]);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + fieldArray[i].getName() + "': " + illegalAccessException);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != (class$java$lang$Object == null ? ReflectionUtils.class$("java.lang.Object") : class$java$lang$Object));
    }

    public static void shallowCopyFieldState(final Object object, final Object object2) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!object.getClass().isAssignableFrom(object2.getClass())) {
            throw new IllegalArgumentException("Destination class [" + object2.getClass().getName() + "] must be same or subclass as source class [" + object.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(object.getClass(), new FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible(field);
                Object object3 = field.get(object);
                field.set(object2, object3);
            }
        }, COPYABLE_FIELDS);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }
}

