/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.comm.ParallelPort;
import javax.comm.UnsupportedCommOperationException;

class LPTMode
extends Choice
implements ItemListener {
    private ParallelPortDisplay owner;

    public LPTMode(ParallelPortDisplay parallelPortDisplay) {
        this.add("Unknown");
        this.add("Any");
        this.add("ECP");
        this.add("EPP");
        this.add("NIBBLE");
        this.add("PS2");
        this.add("SPP");
        this.addItemListener((ItemListener)this);
        this.owner = parallelPortDisplay;
    }

    protected void showValue() {
        ParallelPort parallelPort = this.owner.port;
        if (this.owner.open) {
            switch (this.owner.port.getMode()) {
                case 0: {
                    this.select("Any");
                    break;
                }
                case 4: {
                    this.select("ECP");
                    break;
                }
                case 3: {
                    this.select("EPP");
                    break;
                }
                case 5: {
                    this.select("NIBBLE");
                    break;
                }
                case 2: {
                    this.select("PS2");
                    break;
                }
                case 1: {
                    this.select("SPP");
                    break;
                }
                default: {
                    this.select("Unknown");
                    break;
                }
            }
        } else {
            this.select("Unknown");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = 0;
        if (string.equals("Any")) {
            n = 0;
        } else if (string.equals("ECP")) {
            n = 4;
        } else if (string.equals("EPP")) {
            n = 3;
        } else if (string.equals("NIBBLE")) {
            n = 5;
        } else if (string.equals("PS2")) {
            n = 2;
        } else if (string.equals("SPP")) {
            n = 1;
        } else {
            this.showValue();
            return;
        }
        ParallelPort parallelPort = this.owner.port;
        if (parallelPort != null) {
            try {
                parallelPort.setMode(n);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                System.out.println("Cannot set mode to " + string + " for port " + parallelPort.getName());
            }
        }
        this.owner.showValues();
    }
}

