/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Alias;
import com.sun.comm.PortmapEntry;
import com.sun.comm.SunrayInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPortIdentifier;

class PortmapDatabase {
    private static Vector portMapEntries = new Vector();
    private static Vector commPortIdentifiers = new Vector();

    PortmapDatabase() {
    }

    public static void loadPortmapFile(String portMapFilename) throws IOException {
        portMapEntries.clear();
        commPortIdentifiers.clear();
        if (portMapFilename == null || portMapFilename.equals("")) {
            return;
        }
        File f = new File(portMapFilename);
        if (!f.isFile() || !f.canRead()) {
            throw new IOException();
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        String srcLine = null;
        int lineNbr = 0;
        while ((srcLine = br.readLine()) != null) {
            ++lineNbr;
            if (srcLine.startsWith("#") || srcLine.trim().equals("")) continue;
            try {
                portMapEntries.add(new PortmapEntry(srcLine));
            }
            catch (IOException e) {
                if (System.getProperty("debug_portmap") == null || e.getMessage() == null) continue;
                System.err.println("\n** [javax.comm: Encountered error during parsing portmap properties]\n**  File: " + portMapFilename + "\n" + "**  Line #" + lineNbr + ":  \"" + srcLine.trim() + "\"\n" + "**  << " + e.getMessage() + " >>\n");
            }
        }
        br.close();
    }

    public static String translatePortname(String portName) throws IOException {
        PortmapEntry pme = PortmapDatabase.findByLogicalName(portName);
        if (pme != null && !pme.isDTUalias()) {
            if (pme.isAssignedToDTU()) {
                String pmeDTUterminalId = PortmapDatabase.findByLogicalName(pme.getDTUname()).getDTUterminalId();
                if (SunrayInfo.getSessionTerminalId().equals(pmeDTUterminalId)) {
                    return pme.getEquatedTarget();
                }
            } else {
                if (pme.isDTUspecificALN() || pme.isSessionLocalALN()) {
                    return pme.getALNpath();
                }
                return pme.getEquatedTarget();
            }
        }
        return portName;
    }

    public static void add(CommPortIdentifier cpi) {
        commPortIdentifiers.add(cpi);
    }

    public static void add(PortmapEntry pme) {
        portMapEntries.add(pme);
    }

    public static Enumeration getCommPortIdentifiers() {
        return commPortIdentifiers.elements();
    }

    public static Enumeration elements() {
        return portMapEntries.elements();
    }

    public static void dump() {
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            System.out.println((PortmapEntry)e.nextElement());
        }
    }

    public static String DTUnameToTerminalId(String dtuName) {
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!pme.isDTUalias() || !dtuName.equals(pme.getDTUname())) continue;
            return pme.getDTUterminalId();
        }
        return null;
    }

    public static String terminalIdToDTUname(String terminalId) {
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!pme.isDTUalias() || !terminalId.equals(pme.getDTUterminalId())) continue;
            return pme.getDTUname();
        }
        return null;
    }

    public static PortmapEntry findByLogicalName(Alias alias) {
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!alias.getBasename().equals(pme.getLogicalName())) continue;
            return pme;
        }
        return null;
    }

    public static PortmapEntry findByLogicalName(String aliasName) {
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!aliasName.equals(pme.getLogicalName())) continue;
            return pme;
        }
        return null;
    }

    public static Enumeration findByEquivName(String equatedName) {
        Vector<PortmapEntry> v = new Vector<PortmapEntry>();
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!equatedName.equals(pme.getEquatedTarget())) continue;
            v.add(pme);
        }
        return v.elements();
    }

    public static Enumeration findByALNpath(String alnPath) {
        Vector<PortmapEntry> v = new Vector<PortmapEntry>();
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!alnPath.equals(pme.getALNpath())) continue;
            v.add(pme);
        }
        return v.elements();
    }

    public static Enumeration findDTUnameRefs(String dtuname) {
        Vector<PortmapEntry> v = new Vector<PortmapEntry>();
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!pme.isGloballyVisible() && (pme.getDTUname() == null || !pme.getDTUname().equals(dtuname))) continue;
            v.add(pme);
        }
        return v.elements();
    }

    public static Enumeration findSessionLocalALNs() {
        Vector<PortmapEntry> v = new Vector<PortmapEntry>();
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!pme.isSessionLocalALN()) continue;
            v.add(pme);
        }
        return v.elements();
    }

    public static Enumeration findDTUspecificALNs() {
        Vector<PortmapEntry> v = new Vector<PortmapEntry>();
        Enumeration e = portMapEntries.elements();
        while (e.hasMoreElements()) {
            PortmapEntry pme = (PortmapEntry)e.nextElement();
            if (!pme.isDTUspecificALN()) continue;
            v.add(pme);
        }
        return v.elements();
    }
}

