/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

public class Util {
    public static void hexdump(byte[] buf, int size) {
        int bufoffset = 0;
        System.out.println("\nDumping " + size + " bytes from input buffer:\n");
        int extraLoop = 0;
        if (size % 16 != 0) {
            extraLoop = 1;
        }
        for (int i = 0; i < size / 16 + extraLoop; ++i) {
            String addr = Integer.toHexString(bufoffset);
            switch (addr.length()) {
                case 0: {
                    addr = "0000" + addr;
                    break;
                }
                case 1: {
                    addr = "000" + addr;
                    break;
                }
                case 2: {
                    addr = "00" + addr;
                    break;
                }
                case 3: {
                    addr = "0" + addr;
                }
            }
            System.out.print(addr + ": ");
            for (int j = 0; j < 16; ++j) {
                String c = "";
                c = j >= size - i * 16 ? "00" : Integer.toHexString(buf[j + bufoffset]);
                if (c.length() < 2) {
                    c = "0" + c;
                } else if (c.length() > 2) {
                    c = c.substring(6);
                }
                System.out.print(c + " ");
                if ((j + 1) % 8 != 0) continue;
                System.out.print(" ");
            }
            for (int k = 0; k < 16; ++k) {
                if (k >= size - i * 16) {
                    System.out.print('.');
                    continue;
                }
                char c = (char)buf[k + bufoffset];
                byte n = buf[k + bufoffset];
                if (n < 32 || n > 127) {
                    c = '.';
                }
                System.out.print(c);
            }
            System.out.println("");
            bufoffset += 16;
        }
        System.out.println("");
    }
}

