/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyMatches;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanWrapperImpl
extends AbstractPropertyAccessor
implements BeanWrapper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$BeanWrapperImpl == null ? (class$org$springframework$beans$BeanWrapperImpl = BeanWrapperImpl.class$("org.springframework.beans.BeanWrapperImpl")) : class$org$springframework$beans$BeanWrapperImpl));
    private Object object;
    private String nestedPath = "";
    private Object rootObject;
    private TypeConverterDelegate typeConverterDelegate;
    private CachedIntrospectionResults cachedIntrospectionResults;
    private Map nestedBeanWrappers;
    static /* synthetic */ Class class$org$springframework$beans$BeanWrapperImpl;

    public BeanWrapperImpl() {
        this(true);
    }

    public BeanWrapperImpl(boolean bl) {
        if (bl) {
            this.registerDefaultEditors();
        }
        this.typeConverterDelegate = new TypeConverterDelegate(this);
    }

    public BeanWrapperImpl(Object object) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object);
    }

    public BeanWrapperImpl(Class clazz) {
        this.registerDefaultEditors();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    public BeanWrapperImpl(Object object, String string, Object object2) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object, string, object2);
    }

    private BeanWrapperImpl(Object object, String string, BeanWrapperImpl beanWrapperImpl) {
        this.setWrappedInstance(object, string, beanWrapperImpl.getWrappedInstance());
        this.setExtractOldValueForEditor(beanWrapperImpl.isExtractOldValueForEditor());
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, String string, Object object2) {
        Assert.notNull((Object)object, (String)"Bean object must not be null");
        this.object = object;
        this.nestedPath = string != null ? string : "";
        this.rootObject = !"".equals(this.nestedPath) ? object2 : object;
        this.nestedBeanWrappers = null;
        this.typeConverterDelegate = new TypeConverterDelegate(this, object);
        this.setIntrospectionClass(object.getClass());
    }

    public final Object getWrappedInstance() {
        return this.object;
    }

    public final Class getWrappedClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    public final String getNestedPath() {
        return this.nestedPath;
    }

    public final Object getRootInstance() {
        return this.rootObject;
    }

    public final Class getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    protected void setIntrospectionClass(Class clazz) {
        if (this.cachedIntrospectionResults == null || !this.cachedIntrospectionResults.getBeanClass().equals(clazz)) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        Assert.state((this.cachedIntrospectionResults != null ? 1 : 0) != 0, (String)"BeanWrapper does not hold a bean instance");
        return this.cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String string) throws BeansException {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptorInternal(string);
        if (propertyDescriptor == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "No property '" + string + "' found");
        }
        return propertyDescriptor;
    }

    protected PropertyDescriptor getPropertyDescriptorInternal(String string) throws BeansException {
        Assert.state((this.cachedIntrospectionResults != null ? 1 : 0) != 0, (String)"BeanWrapper does not hold a bean instance");
        Assert.notNull((Object)string, (String)"Property name must not be null");
        BeanWrapperImpl beanWrapperImpl = this.getBeanWrapperForPropertyPath(string);
        return beanWrapperImpl.cachedIntrospectionResults.getPropertyDescriptor(this.getFinalPath(beanWrapperImpl, string));
    }

    public Class getPropertyType(String string) throws BeansException {
        try {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptorInternal(string);
            if (propertyDescriptor != null) {
                return propertyDescriptor.getPropertyType();
            }
            Object object = this.getPropertyValue(string);
            if (object != null) {
                return object.getClass();
            }
            Class clazz = this.guessPropertyTypeFromEditors(string);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    public boolean isReadableProperty(String string) {
        block4: {
            try {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptorInternal(string);
                if (propertyDescriptor != null) {
                    if (propertyDescriptor.getReadMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(string);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isWritableProperty(String string) {
        block4: {
            try {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptorInternal(string);
                if (propertyDescriptor != null) {
                    if (propertyDescriptor.getWriteMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(string);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    public Object doTypeConversionIfNecessary(Object object, Class clazz) throws TypeMismatchException {
        return this.convertIfNecessary(object, clazz, null);
    }

    public Object convertIfNecessary(Object object, Class clazz) throws TypeMismatchException {
        return this.convertIfNecessary(object, clazz, null);
    }

    public Object convertIfNecessary(Object object, Class clazz, MethodParameter methodParameter) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(object, clazz, methodParameter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TypeMismatchException(object, clazz, (Throwable)illegalArgumentException);
        }
    }

    public Object convertForProperty(Object object, String string) throws TypeMismatchException {
        PropertyDescriptor propertyDescriptor = this.cachedIntrospectionResults.getPropertyDescriptor(string);
        if (propertyDescriptor == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "No property '" + string + "' found");
        }
        try {
            return this.typeConverterDelegate.convertIfNecessary(null, object, propertyDescriptor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, null, object);
            throw new TypeMismatchException(propertyChangeEvent, propertyDescriptor.getPropertyType(), (Throwable)illegalArgumentException);
        }
    }

    private String getFinalPath(BeanWrapper beanWrapper, String string) {
        if (beanWrapper == this) {
            return string;
        }
        return string.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(string) + 1);
    }

    protected BeanWrapperImpl getBeanWrapperForPropertyPath(String string) {
        int n = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(string);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            BeanWrapperImpl beanWrapperImpl = this.getNestedBeanWrapper(string2);
            return beanWrapperImpl.getBeanWrapperForPropertyPath(string3);
        }
        return this;
    }

    private BeanWrapperImpl getNestedBeanWrapper(String string) {
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap();
        }
        PropertyTokenHolder propertyTokenHolder = this.getPropertyNameTokens(string);
        String string2 = propertyTokenHolder.canonicalName;
        Object object = this.getPropertyValue(propertyTokenHolder);
        if (object == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + string2);
        }
        BeanWrapperImpl beanWrapperImpl = (BeanWrapperImpl)this.nestedBeanWrappers.get(string2);
        if (beanWrapperImpl == null || beanWrapperImpl.getWrappedInstance() != object) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Creating new nested BeanWrapper for property '" + string2 + "'"));
            }
            beanWrapperImpl = this.newNestedBeanWrapper(object, this.nestedPath + string2 + ".");
            this.copyDefaultEditorsTo(beanWrapperImpl);
            this.copyCustomEditorsTo(beanWrapperImpl, string2);
            this.nestedBeanWrappers.put(string2, beanWrapperImpl);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("Using cached nested BeanWrapper for property '" + string2 + "'"));
        }
        return beanWrapperImpl;
    }

    protected BeanWrapperImpl newNestedBeanWrapper(Object object, String string) {
        return new BeanWrapperImpl(object, string, this);
    }

    private PropertyTokenHolder getPropertyNameTokens(String string) {
        PropertyTokenHolder propertyTokenHolder = new PropertyTokenHolder();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>(2);
        int n = 0;
        while (n != -1) {
            String string3;
            int n2;
            int n3 = string.indexOf("[", n);
            n = -1;
            if (n3 == -1 || (n2 = string.indexOf("]", n3 + "[".length())) == -1) continue;
            if (string2 == null) {
                string2 = string.substring(0, n3);
            }
            if ((string3 = string.substring(n3 + "[".length(), n2)).startsWith("'") && string3.endsWith("'") || string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            arrayList.add(string3);
            n = n2 + "]".length();
        }
        propertyTokenHolder.canonicalName = propertyTokenHolder.actualName = string2 != null ? string2 : string;
        if (!arrayList.isEmpty()) {
            propertyTokenHolder.canonicalName = propertyTokenHolder.canonicalName + "[" + StringUtils.collectionToDelimitedString(arrayList, (String)"][") + "]";
            propertyTokenHolder.keys = StringUtils.toStringArray(arrayList);
        }
        return propertyTokenHolder;
    }

    public Object getPropertyValue(String string) throws BeansException {
        BeanWrapperImpl beanWrapperImpl = this.getBeanWrapperForPropertyPath(string);
        PropertyTokenHolder propertyTokenHolder = this.getPropertyNameTokens(this.getFinalPath(beanWrapperImpl, string));
        return beanWrapperImpl.getPropertyValue(propertyTokenHolder);
    }

    private Object getPropertyValue(PropertyTokenHolder propertyTokenHolder) throws BeansException {
        String string = propertyTokenHolder.canonicalName;
        String string2 = propertyTokenHolder.actualName;
        PropertyDescriptor propertyDescriptor = this.cachedIntrospectionResults.getPropertyDescriptor(string2);
        if (propertyDescriptor == null || propertyDescriptor.getReadMethod() == null) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + string);
        }
        Method method = propertyDescriptor.getReadMethod();
        try {
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            Object object = method.invoke(this.object, (Object[])null);
            if (propertyTokenHolder.keys != null) {
                block5: for (int i = 0; i < propertyTokenHolder.keys.length; ++i) {
                    Object object2;
                    Object object3;
                    String string3 = propertyTokenHolder.keys[i];
                    if (object == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + string, "Cannot access indexed value of property referenced in indexed property path '" + string + "': returned null");
                    }
                    if (object.getClass().isArray()) {
                        object = Array.get(object, Integer.parseInt(string3));
                        continue;
                    }
                    if (object instanceof List) {
                        object3 = (List)object;
                        object = object3.get(Integer.parseInt(string3));
                        continue;
                    }
                    if (object instanceof Set) {
                        object3 = (Set)object;
                        int n = Integer.parseInt(string3);
                        if (n < 0 || n >= object3.size()) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Cannot get element with index " + n + " from Set of size " + object3.size() + ", accessed using property path '" + string + "'");
                        }
                        object2 = object3.iterator();
                        int n2 = 0;
                        while (object2.hasNext()) {
                            Object e = object2.next();
                            if (n2 == n) {
                                object = e;
                                continue block5;
                            }
                            ++n2;
                        }
                        continue;
                    }
                    if (object instanceof Map) {
                        object3 = (Map)object;
                        Class clazz = null;
                        if (JdkVersion.isAtLeastJava15()) {
                            clazz = GenericCollectionTypeResolver.getMapKeyReturnType((Method)propertyDescriptor.getReadMethod(), (int)(i + 1));
                        }
                        object2 = this.typeConverterDelegate.convertIfNecessary(string3, clazz);
                        object = object3.get(object2);
                        continue;
                    }
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Property referenced in indexed property path '" + string + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + object + "]");
                }
            }
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Getter for property '" + string2 + "' threw exception", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Illegal attempt to get property '" + string2 + "' threw exception", illegalAccessException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Index of out of bounds in property path '" + string + "'", indexOutOfBoundsException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Invalid index in property path '" + string + "'", numberFormatException);
        }
    }

    public void setPropertyValue(String string, Object object) throws BeansException {
        BeanWrapperImpl beanWrapperImpl = null;
        try {
            beanWrapperImpl = this.getBeanWrapperForPropertyPath(string);
        }
        catch (NotReadablePropertyException notReadablePropertyException) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + string, "Nested property in path '" + string + "' does not exist", (Throwable)((Object)notReadablePropertyException));
        }
        PropertyTokenHolder propertyTokenHolder = this.getPropertyNameTokens(this.getFinalPath(beanWrapperImpl, string));
        beanWrapperImpl.setPropertyValue(propertyTokenHolder, new PropertyValue(string, object));
    }

    public void setPropertyValue(PropertyValue propertyValue) throws BeansException {
        PropertyTokenHolder propertyTokenHolder = (PropertyTokenHolder)propertyValue.resolvedTokens;
        if (propertyTokenHolder == null) {
            String string = propertyValue.getName();
            BeanWrapperImpl beanWrapperImpl = null;
            try {
                beanWrapperImpl = this.getBeanWrapperForPropertyPath(string);
            }
            catch (NotReadablePropertyException notReadablePropertyException) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + string, "Nested property in path '" + string + "' does not exist", (Throwable)((Object)notReadablePropertyException));
            }
            propertyTokenHolder = this.getPropertyNameTokens(this.getFinalPath(beanWrapperImpl, string));
            if (beanWrapperImpl == this) {
                propertyValue.resolvedTokens = propertyTokenHolder;
            }
            beanWrapperImpl.setPropertyValue(propertyTokenHolder, propertyValue);
        } else {
            this.setPropertyValue(propertyTokenHolder, propertyValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyValue(PropertyTokenHolder propertyTokenHolder, PropertyValue propertyValue) throws BeansException {
        Object object;
        Object object2;
        PropertyDescriptor propertyDescriptor;
        String string;
        block34: {
            string = propertyTokenHolder.canonicalName;
            String string2 = propertyTokenHolder.actualName;
            if (propertyTokenHolder.keys != null) {
                PropertyTokenHolder propertyTokenHolder2 = new PropertyTokenHolder();
                propertyTokenHolder2.canonicalName = propertyTokenHolder.canonicalName;
                propertyTokenHolder2.actualName = propertyTokenHolder.actualName;
                propertyTokenHolder2.keys = new String[propertyTokenHolder.keys.length - 1];
                System.arraycopy(propertyTokenHolder.keys, 0, propertyTokenHolder2.keys, 0, propertyTokenHolder.keys.length - 1);
                Object object3 = null;
                try {
                    object3 = this.getPropertyValue(propertyTokenHolder2);
                }
                catch (NotReadablePropertyException notReadablePropertyException) {
                    throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + string, "Cannot access indexed value in property referenced in indexed property path '" + string + "'", (Throwable)((Object)notReadablePropertyException));
                }
                String string3 = propertyTokenHolder.keys[propertyTokenHolder.keys.length - 1];
                if (object3 == null) {
                    throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + string, "Cannot access indexed value in property referenced in indexed property path '" + string + "': returned null");
                }
                if (object3.getClass().isArray()) {
                    Class<?> clazz = object3.getClass().getComponentType();
                    int n = Integer.parseInt(string3);
                    Object object4 = null;
                    try {
                        if (this.isExtractOldValueForEditor()) {
                            object4 = Array.get(object3, n);
                        }
                        Object object5 = this.typeConverterDelegate.convertIfNecessary(string, object4, propertyValue.getValue(), clazz);
                        Array.set(object3, Integer.parseInt(string3), object5);
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, object4, propertyValue.getValue());
                        throw new TypeMismatchException(propertyChangeEvent, clazz, (Throwable)illegalArgumentException);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Invalid array index in property path '" + string + "'", indexOutOfBoundsException);
                    }
                }
                if (object3 instanceof List) {
                    PropertyDescriptor propertyDescriptor2 = this.cachedIntrospectionResults.getPropertyDescriptor(string2);
                    Class clazz = null;
                    if (JdkVersion.isAtLeastJava15()) {
                        clazz = GenericCollectionTypeResolver.getCollectionReturnType((Method)propertyDescriptor2.getReadMethod(), (int)propertyTokenHolder.keys.length);
                    }
                    List list = (List)object3;
                    int n = Integer.parseInt(string3);
                    Object var12_36 = null;
                    if (this.isExtractOldValueForEditor() && n < list.size()) {
                        var12_36 = list.get(n);
                    }
                    try {
                        Object object6 = this.typeConverterDelegate.convertIfNecessary(string, var12_36, propertyValue.getValue(), clazz);
                        if (n < list.size()) {
                            list.set(n, object6);
                            return;
                        }
                        if (n < list.size()) return;
                        for (int i = list.size(); i < n; ++i) {
                            try {
                                list.add(null);
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Cannot set element with index " + n + " in List of size " + list.size() + ", accessed using property path '" + string + "': List does not support filling up gaps with null elements");
                            }
                        }
                        list.add(object6);
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, var12_36, propertyValue.getValue());
                        throw new TypeMismatchException(propertyChangeEvent, clazz, (Throwable)illegalArgumentException);
                    }
                }
                if (!(object3 instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + string, "Property referenced in indexed property path '" + string + "' is neither an array nor a List nor a Map; returned value was [" + propertyValue.getValue() + "]");
                PropertyDescriptor propertyDescriptor3 = this.cachedIntrospectionResults.getPropertyDescriptor(string2);
                Class clazz = null;
                Class clazz2 = null;
                if (JdkVersion.isAtLeastJava15()) {
                    clazz = GenericCollectionTypeResolver.getMapKeyReturnType((Method)propertyDescriptor3.getReadMethod(), (int)propertyTokenHolder.keys.length);
                    clazz2 = GenericCollectionTypeResolver.getMapValueReturnType((Method)propertyDescriptor3.getReadMethod(), (int)propertyTokenHolder.keys.length);
                }
                Map map = (Map)object3;
                Object var12_37 = null;
                if (this.isExtractOldValueForEditor()) {
                    var12_37 = map.get(string3);
                }
                Object object7 = null;
                Object object8 = null;
                try {
                    object7 = this.typeConverterDelegate.convertIfNecessary(string3, clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, var12_37, propertyValue.getValue());
                    throw new TypeMismatchException(propertyChangeEvent, clazz, (Throwable)illegalArgumentException);
                }
                try {
                    object8 = this.typeConverterDelegate.convertIfNecessary(string, var12_37, propertyValue.getValue(), clazz2, null, new MethodParameter(propertyDescriptor3.getReadMethod(), -1, propertyTokenHolder.keys.length + 1));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, var12_37, propertyValue.getValue());
                    throw new TypeMismatchException(propertyChangeEvent, clazz2, (Throwable)illegalArgumentException);
                }
                map.put(object7, object8);
                return;
            }
            propertyDescriptor = this.cachedIntrospectionResults.getPropertyDescriptor(string2);
            if (propertyDescriptor == null || propertyDescriptor.getWriteMethod() == null) {
                PropertyMatches propertyMatches = PropertyMatches.forProperty(string, this.getRootClass());
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + string, propertyMatches.buildErrorMessage(), propertyMatches.getPossibleMatches());
            }
            object2 = null;
            if (this.isExtractOldValueForEditor() && propertyDescriptor.getReadMethod() != null) {
                object = propertyDescriptor.getReadMethod();
                if (!Modifier.isPublic(((Method)object).getDeclaringClass().getModifiers())) {
                    ((Method)object).setAccessible(true);
                }
                try {
                    object2 = ((Method)object).invoke(this.object, new Object[0]);
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) break block34;
                    logger.debug((Object)("Could not read previous value of property '" + this.nestedPath + string + "'"), (Throwable)exception);
                }
            }
        }
        try {
            object = propertyValue.isConverted() ? propertyValue.getConvertedValue() : this.typeConverterDelegate.convertIfNecessary(object2, propertyValue.getValue(), propertyDescriptor);
            Method method = propertyDescriptor.getWriteMethod();
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            method.invoke(this.object, object);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, object2, propertyValue.getValue());
            if (!(invocationTargetException.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(propertyChangeEvent, invocationTargetException.getTargetException());
            throw new TypeMismatchException(propertyChangeEvent, propertyDescriptor.getPropertyType(), invocationTargetException.getTargetException());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, object2, propertyValue.getValue());
            throw new TypeMismatchException(propertyChangeEvent, propertyDescriptor.getPropertyType(), (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + string, object2, propertyValue.getValue());
            throw new MethodInvocationException(propertyChangeEvent, (Throwable)illegalAccessException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        if (this.object != null) {
            stringBuffer.append(": wrapping object [").append(ObjectUtils.identityToString((Object)this.object)).append("]");
        } else {
            stringBuffer.append(": no wrapped object set");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

