/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.util.ObjectUtils;

public abstract class PropertyResourceConfigurer
extends PropertiesLoaderSupport
implements BeanFactoryPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        try {
            Properties properties = this.mergeProperties();
            this.convertProperties(properties);
            this.processProperties(configurableListableBeanFactory, properties);
        }
        catch (IOException iOException) {
            throw new BeanInitializationException("Could not load properties", iOException);
        }
    }

    protected void convertProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (ObjectUtils.nullSafeEquals((Object)string3, (Object)(string = this.convertPropertyValue(string3)))) continue;
            properties.setProperty(string2, string);
        }
    }

    protected String convertPropertyValue(String string) {
        return string;
    }

    protected abstract void processProperties(ConfigurableListableBeanFactory var1, Properties var2) throws BeansException;
}

