/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LookupOverride
extends MethodOverride {
    private final String beanName;

    public LookupOverride(String string, String string2) {
        super(string);
        Assert.notNull((Object)string2, (String)"Bean name must not be null");
        this.beanName = string2;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean matches(Method method) {
        return method.getName().equals(this.getMethodName()) && method.getParameterTypes().length == 0;
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'; will return bean '" + this.beanName + "'";
    }

    public boolean equals(Object object) {
        return object instanceof LookupOverride && super.equals(object) && ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)((LookupOverride)object).beanName);
    }

    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode((Object)this.beanName);
    }
}

