/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class CustomBooleanEditor
extends PropertyEditorSupport {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_ON = "on";
    public static final String VALUE_OFF = "off";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String VALUE_1 = "1";
    public static final String VALUE_0 = "0";
    private final String trueString;
    private final String falseString;
    private final boolean allowEmpty;

    public CustomBooleanEditor(boolean bl) {
        this(null, null, bl);
    }

    public CustomBooleanEditor(String string, String string2, boolean bl) {
        this.trueString = string;
        this.falseString = string2;
        this.allowEmpty = bl;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)string)) {
            this.setValue(null);
        } else if (this.trueString != null && string.equalsIgnoreCase(this.trueString)) {
            this.setValue(Boolean.TRUE);
        } else if (this.falseString != null && string.equalsIgnoreCase(this.falseString)) {
            this.setValue(Boolean.FALSE);
        } else if (this.trueString == null && (string.equalsIgnoreCase(VALUE_TRUE) || string.equalsIgnoreCase(VALUE_ON) || string.equalsIgnoreCase(VALUE_YES) || string.equals(VALUE_1))) {
            this.setValue(Boolean.TRUE);
        } else if (this.falseString == null && (string.equalsIgnoreCase(VALUE_FALSE) || string.equalsIgnoreCase(VALUE_OFF) || string.equalsIgnoreCase(VALUE_NO) || string.equals(VALUE_0))) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException("Invalid boolean value [" + string + "]");
        }
    }

    public String getAsText() {
        if (Boolean.TRUE.equals(this.getValue())) {
            return this.trueString != null ? this.trueString : VALUE_TRUE;
        }
        if (Boolean.FALSE.equals(this.getValue())) {
            return this.falseString != null ? this.falseString : VALUE_FALSE;
        }
        return "";
    }
}

