/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class FileEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public FileEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public FileEditor(ResourceEditor resourceEditor) {
        Assert.notNull((Object)resourceEditor, (String)"ResourceEditor must not be null");
        this.resourceEditor = resourceEditor;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        File file;
        if (StringUtils.hasText((String)string) && !ResourceUtils.isUrl((String)string) && (file = new File(string)).isAbsolute()) {
            this.setValue(file);
            return;
        }
        this.resourceEditor.setAsText(string);
        file = (Resource)this.resourceEditor.getValue();
        try {
            this.setValue(file != null ? file.getFile() : null);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not retrieve File for " + file + ": " + iOException.getMessage());
        }
    }

    public String getAsText() {
        File file = (File)this.getValue();
        return file != null ? file.getPath() : "";
    }
}

