/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.jaxb;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.XMLStreamException2;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import com.sun.xml.internal.ws.message.RootElementSniffer;
import com.sun.xml.internal.ws.message.jaxb.JAXBBridgeSource;
import com.sun.xml.internal.ws.message.jaxb.MarshallerBridge;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterUtil;
import java.io.OutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class JAXBHeader
extends AbstractHeaderImpl {
    private final Object jaxbObject;
    private final Bridge bridge;
    private String nsUri;
    private String localName;
    private Attributes atts;
    private XMLStreamBuffer infoset;

    public JAXBHeader(JAXBRIContext jAXBRIContext, Object object) {
        this.jaxbObject = object;
        this.bridge = new MarshallerBridge(jAXBRIContext);
        if (object instanceof JAXBElement) {
            JAXBElement jAXBElement = (JAXBElement)object;
            this.nsUri = jAXBElement.getName().getNamespaceURI();
            this.localName = jAXBElement.getName().getLocalPart();
        }
    }

    public JAXBHeader(Bridge bridge, Object object) {
        this.jaxbObject = object;
        this.bridge = bridge;
        QName qName = bridge.getTypeReference().tagName;
        this.nsUri = qName.getNamespaceURI();
        this.localName = qName.getLocalPart();
    }

    private void parse() {
        RootElementSniffer rootElementSniffer = new RootElementSniffer();
        try {
            this.bridge.marshal(this.jaxbObject, rootElementSniffer);
        }
        catch (JAXBException jAXBException) {
            this.nsUri = rootElementSniffer.getNsUri();
            this.localName = rootElementSniffer.getLocalName();
            this.atts = rootElementSniffer.getAttributes();
        }
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        if (this.nsUri == null) {
            this.parse();
        }
        return this.nsUri;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        if (this.localName == null) {
            this.parse();
        }
        return this.localName;
    }

    @Override
    public String getAttribute(String string, String string2) {
        if (this.atts == null) {
            this.parse();
        }
        return this.atts.getValue(string, string2);
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        try {
            if (this.infoset == null) {
                XMLStreamBufferResult xMLStreamBufferResult = new XMLStreamBufferResult();
                this.bridge.marshal(this.jaxbObject, xMLStreamBufferResult);
                this.infoset = xMLStreamBufferResult.getXMLStreamBuffer();
            }
            return this.infoset.readAsXMLStreamReader();
        }
        catch (JAXBException jAXBException) {
            throw new XMLStreamException2(jAXBException);
        }
    }

    @Override
    public <T> T readAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        try {
            JAXBResult jAXBResult = new JAXBResult(unmarshaller);
            jAXBResult.getHandler().startDocument();
            this.bridge.marshal(this.jaxbObject, jAXBResult);
            jAXBResult.getHandler().endDocument();
            return (T)jAXBResult.getResult();
        }
        catch (SAXException sAXException) {
            throw new JAXBException(sAXException);
        }
    }

    @Override
    public <T> T readAsJAXB(Bridge<T> bridge) throws JAXBException {
        return bridge.unmarshal(new JAXBBridgeSource(this.bridge, this.jaxbObject));
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            OutputStream outputStream = XMLStreamWriterUtil.getOutputStream(xMLStreamWriter);
            if (outputStream != null) {
                this.bridge.marshal(this.jaxbObject, outputStream, xMLStreamWriter.getNamespaceContext());
            } else {
                this.bridge.marshal(this.jaxbObject, xMLStreamWriter);
            }
        }
        catch (JAXBException jAXBException) {
            throw new XMLStreamException2(jAXBException);
        }
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        try {
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                sOAPHeader = sOAPMessage.getSOAPPart().getEnvelope().addHeader();
            }
            this.bridge.marshal(this.jaxbObject, sOAPHeader);
        }
        catch (JAXBException jAXBException) {
            throw new SOAPException(jAXBException);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        try {
            this.bridge.marshal(this.jaxbObject, contentHandler);
        }
        catch (JAXBException jAXBException) {
            SAXParseException sAXParseException = new SAXParseException(jAXBException.getMessage(), null, null, -1, -1, jAXBException);
            errorHandler.fatalError(sAXParseException);
            throw sAXParseException;
        }
    }
}

