/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.PolicyMapKeyHandler;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;

public final class PolicyMapKey {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyMapKey.class);
    private final QName service;
    private final QName port;
    private final QName operation;
    private final QName faultMessage;
    private PolicyMapKeyHandler handler;

    PolicyMapKey(QName qName, QName qName2, QName qName3, PolicyMapKeyHandler policyMapKeyHandler) {
        this(qName, qName2, qName3, null, policyMapKeyHandler);
    }

    PolicyMapKey(QName qName, QName qName2, QName qName3, QName qName4, PolicyMapKeyHandler policyMapKeyHandler) {
        if (policyMapKeyHandler == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0046_POLICY_MAP_KEY_HANDLER_NOT_SET()));
        }
        this.service = qName;
        this.port = qName2;
        this.operation = qName3;
        this.faultMessage = qName4;
        this.handler = policyMapKeyHandler;
    }

    PolicyMapKey(PolicyMapKey policyMapKey) {
        this.service = policyMapKey.service;
        this.port = policyMapKey.port;
        this.operation = policyMapKey.operation;
        this.faultMessage = policyMapKey.faultMessage;
        this.handler = policyMapKey.handler;
    }

    public QName getOperation() {
        return this.operation;
    }

    public QName getPort() {
        return this.port;
    }

    public QName getService() {
        return this.service;
    }

    void setHandler(PolicyMapKeyHandler policyMapKeyHandler) {
        if (policyMapKeyHandler == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0046_POLICY_MAP_KEY_HANDLER_NOT_SET()));
        }
        this.handler = policyMapKeyHandler;
    }

    public QName getFaultMessage() {
        return this.faultMessage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof PolicyMapKey) {
            return this.handler.areEqual(this, (PolicyMapKey)object);
        }
        return false;
    }

    public int hashCode() {
        return this.handler.generateHashCode(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PolicyMapKey(");
        stringBuffer.append(this.service).append(", ").append(this.port).append(", ").append(this.operation).append(", ").append(this.faultMessage);
        return stringBuffer.append(")").toString();
    }
}

