/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5;

import java.awt.Toolkit;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.lf5.AppenderFinalizer;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class LF5Appender
extends AppenderSkeleton {
    protected LogBrokerMonitor _logMonitor;
    protected static LogBrokerMonitor _defaultLogMonitor;
    protected static AppenderFinalizer _finalizer;

    public LF5Appender() {
        this(LF5Appender.getDefaultInstance());
    }

    public LF5Appender(LogBrokerMonitor logBrokerMonitor) {
        if (logBrokerMonitor != null) {
            this._logMonitor = logBrokerMonitor;
        }
    }

    public void append(LoggingEvent loggingEvent) {
        String string = loggingEvent.getLoggerName();
        String string2 = loggingEvent.getRenderedMessage();
        String string3 = loggingEvent.getNDC();
        String string4 = loggingEvent.getThreadName();
        String string5 = loggingEvent.getLevel().toString();
        long l = loggingEvent.timeStamp;
        LocationInfo locationInfo = loggingEvent.getLocationInformation();
        Log4JLogRecord log4JLogRecord = new Log4JLogRecord();
        log4JLogRecord.setCategory(string);
        log4JLogRecord.setMessage(string2);
        log4JLogRecord.setLocation(locationInfo.fullInfo);
        log4JLogRecord.setMillis(l);
        log4JLogRecord.setThreadDescription(string4);
        if (string3 != null) {
            log4JLogRecord.setNDC(string3);
        } else {
            log4JLogRecord.setNDC("");
        }
        if (loggingEvent.getThrowableInformation() != null) {
            log4JLogRecord.setThrownStackTrace(loggingEvent.getThrowableInformation());
        }
        try {
            log4JLogRecord.setLevel(LogLevel.valueOf(string5));
        }
        catch (LogLevelFormatException logLevelFormatException) {
            log4JLogRecord.setLevel(LogLevel.WARN);
        }
        if (this._logMonitor != null) {
            this._logMonitor.addMessage(log4JLogRecord);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setCallSystemExitOnClose(boolean bl) {
        this._logMonitor.setCallSystemExitOnClose(bl);
    }

    public boolean equals(LF5Appender lF5Appender) {
        return this._logMonitor == lF5Appender.getLogBrokerMonitor();
    }

    public LogBrokerMonitor getLogBrokerMonitor() {
        return this._logMonitor;
    }

    public static void main(String[] stringArray) {
        new LF5Appender();
    }

    public void setMaxNumberOfRecords(int n) {
        _defaultLogMonitor.setMaxNumberOfLogRecords(n);
    }

    protected static synchronized LogBrokerMonitor getDefaultInstance() {
        if (_defaultLogMonitor == null) {
            try {
                _defaultLogMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels());
                _finalizer = new AppenderFinalizer(_defaultLogMonitor);
                _defaultLogMonitor.setFrameSize(LF5Appender.getDefaultMonitorWidth(), LF5Appender.getDefaultMonitorHeight());
                _defaultLogMonitor.setFontSize(12);
                _defaultLogMonitor.show();
            }
            catch (SecurityException securityException) {
                _defaultLogMonitor = null;
            }
        }
        return _defaultLogMonitor;
    }

    protected static int getScreenWidth() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().width;
        }
        catch (Throwable throwable) {
            return 800;
        }
    }

    protected static int getScreenHeight() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        catch (Throwable throwable) {
            return 600;
        }
    }

    protected static int getDefaultMonitorWidth() {
        return 3 * LF5Appender.getScreenWidth() / 4;
    }

    protected static int getDefaultMonitorHeight() {
        return 3 * LF5Appender.getScreenHeight() / 4;
    }
}

