/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.Eventcfg;
import cn.com.voltronic.solar.dbtools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EventCfgDao
extends BaseDao {
    private final String INSERT_CFG = "insert into EVENT_CFG(EVENTID,ACTION,RECEIVE) values(?,?,?)";
    private final String QUERY_EVENTCFG = "SELECT * FROM EVENT_CFG WHERE EVENTID = ? ";
    private final String DELETE_EVENTCFG = "DELETE FROM EVENT_CFG WHERE EVENTID=? ";
    private final String DELETE_EVENTCFG_ALL = "DELETE FROM EVENT_CFG";
    private final String QUERY_ALL_EVENT_ID = "SELECT DISTINCT EVENTID FROM EVENT_CFG";

    public boolean insertCfg(Eventcfg eventCfg) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("insert into EVENT_CFG(EVENTID,ACTION,RECEIVE) values(?,?,?)");
                ps.setString(1, eventCfg.getEventid());
                ps.setInt(2, eventCfg.getAction());
                ps.setString(3, eventCfg.getReceive());
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception ex) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<Eventcfg> queryEventcfg(String eventid) {
        ArrayList<Eventcfg> result;
        block6: {
            result = new ArrayList<Eventcfg>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT * FROM EVENT_CFG WHERE EVENTID = ? ");
                    ps.setString(1, eventid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        Eventcfg e = new Eventcfg();
                        e.setEventid(rs.getString("eventid"));
                        e.setAction(rs.getInt("action"));
                        e.setReceive(rs.getString("receive"));
                        result.add(e);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean removeEventcfg(String saveEventId) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        if (conn != null) {
            try {
                try {
                    ps = conn.prepareStatement("DELETE FROM EVENT_CFG WHERE EVENTID=? ");
                    ps.setString(1, saveEventId);
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                }
            }
            finally {
                this.close(ps);
            }
        }
        return result;
    }

    public boolean removeEventcfgAll() {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        if (conn != null) {
            try {
                try {
                    ps = conn.prepareStatement("DELETE FROM EVENT_CFG");
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(ps);
                }
            }
            finally {
                this.close(ps);
            }
        }
        return result;
    }

    public List<String> queryAllEventId() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT DISTINCT EVENTID FROM EVENT_CFG");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("eventid"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean pollInsertCfg(List<Eventcfg> events) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                for (Eventcfg eventCfg : events) {
                    ps = conn.prepareStatement("insert into EVENT_CFG(EVENTID,ACTION,RECEIVE) values(?,?,?)");
                    ps.setString(1, eventCfg.getEventid());
                    ps.setInt(2, eventCfg.getAction());
                    ps.setString(3, eventCfg.getReceive());
                    ps.executeUpdate();
                    conn.commit();
                }
            }
            catch (Exception ex) {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        Eventcfg eventCfg2;
        Eventcfg eventCfg;
        EventCfgDao dao = new EventCfgDao();
        boolean re = dao.removeEventcfgAll();
        System.out.println("re:" + re);
        int i = 1001;
        while (i < 1099) {
            eventCfg = new Eventcfg();
            eventCfg.setAction(1);
            eventCfg.setEventid(String.valueOf(i));
            eventCfg.setReceive(null);
            dao.insertCfg(eventCfg);
            eventCfg2 = new Eventcfg();
            eventCfg2.setAction(2);
            eventCfg2.setEventid(String.valueOf(i));
            eventCfg2.setReceive(null);
            dao.insertCfg(eventCfg2);
            ++i;
        }
        i = 2001;
        while (i < 2099) {
            eventCfg = new Eventcfg();
            eventCfg.setAction(1);
            eventCfg.setEventid(String.valueOf(i));
            eventCfg.setReceive(null);
            dao.insertCfg(eventCfg);
            eventCfg2 = new Eventcfg();
            eventCfg2.setAction(2);
            eventCfg2.setEventid(String.valueOf(i));
            eventCfg2.setReceive(null);
            dao.insertCfg(eventCfg2);
            ++i;
        }
        i = 3001;
        while (i < 3099) {
            eventCfg = new Eventcfg();
            eventCfg.setAction(1);
            eventCfg.setEventid(String.valueOf(i));
            eventCfg.setReceive(null);
            dao.insertCfg(eventCfg);
            eventCfg2 = new Eventcfg();
            eventCfg2.setAction(2);
            eventCfg2.setEventid(String.valueOf(i));
            eventCfg2.setReceive(null);
            dao.insertCfg(eventCfg2);
            ++i;
        }
    }
}

