/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.modbusprocessor;

import cn.com.voltronic.solar.beanbag.P42BeanBag;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.control.P42ModbusControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.modbusprocessor.AbstractModbusProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import java.util.Date;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.util.BitVector;
import org.apache.log4j.Logger;

public class P42ModbusProcessor
extends AbstractModbusProcessor {
    private static Logger logger = Logger.getLogger(P42ModbusProcessor.class);
    private int oldFaultCode = 0;
    public static int modetypeNum = 0;

    public P42ModbusProcessor(ModbusHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        info.setSerialno(this._protocol.getSerialNo());
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P42BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P42ModbusControlModule(this.getHandler());
    }

    @Override
    public boolean pollQuery() {
        ModbusHandler handler;
        block21: {
            try {
                handler = this.getHandler();
                if (handler != null) break block21;
                logger.error((Object)"pollQuery close");
                this.close();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workinfo.setProdid(this._protocol.getProtocolID());
        workinfo.setSerialNo(this._protocol.getSerialNo());
        workinfo.setCurrentTime(new Date());
        Register[] regs = handler.readMultipleRegisters(67, 1);
        if (regs != null && !handler.getMachineType().equals("11")) {
            int inputSource = regs[0].getValue();
            workinfo.setInputSource(inputSource);
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            if (inputSource == 0) {
                configdata.setInputSource("PV");
            } else if (inputSource == 1) {
                configdata.setInputSource("AC");
            }
        }
        if ((regs = handler.readMultipleRegisters(63, 1)) != null) {
            int workMode = regs[0].getValue();
            switch (workMode) {
                case 0: {
                    workinfo.setWorkMode("Power On Mode");
                    break;
                }
                case 1: {
                    workinfo.setWorkMode("Standby Mode");
                    break;
                }
                case 2: {
                    if (handler.getMachineType().equals("11")) {
                        workinfo.setWorkMode("PV Mode");
                        break;
                    }
                    workinfo.setWorkMode("Output Mode");
                    break;
                }
                case 3: {
                    if (handler.getMachineType().equals("11")) {
                        workinfo.setWorkMode("Line Mode");
                        break;
                    }
                    workinfo.setWorkMode("Fault Mode");
                    break;
                }
                case 4: {
                    if (handler.getMachineType().equals("11")) {
                        workinfo.setWorkMode("Fault Mode");
                        break;
                    }
                    workinfo.setWorkMode("Shutdown Mode");
                    break;
                }
                case 5: {
                    workinfo.setWorkMode("Shutdown Mode");
                    break;
                }
                default: {
                    workinfo.setWorkMode("---");
                }
            }
        }
        if ((regs = handler.readMultipleRegisters(27, 19)) != null) {
            int tempMachine = regs[0].getValue();
            int tempEnvironment = regs[1].getValue();
            double inputVoltagePV = (double)regs[2].getValue() / 10.0;
            double inputVoltageBUS = (double)regs[3].getValue() / 10.0;
            double outputVoltageUV = (double)regs[4].getValue() / 10.0;
            double outputVoltageVW = (double)regs[5].getValue() / 10.0;
            double outputFrequency = (double)regs[6].getValue() / 100.0;
            double outputCurrentU = (double)regs[7].getValue() / 100.0;
            double outputCurrentV = (double)regs[8].getValue() / 100.0;
            double outputCurrentW = (double)regs[9].getValue() / 100.0;
            int outputVoltageAdjustValueUV = regs[10].getValue();
            int outputVoltageAdjustValueVW = regs[11].getValue();
            int outputCurrentAdjustValueU = regs[12].getValue();
            int outputCurrentAdjustValueV = regs[13].getValue();
            int outputCurrentAdjustValueW = regs[14].getValue();
            int outputPowerU = regs[15].getValue();
            int outputPowerV = regs[16].getValue();
            int outputPowerW = regs[17].getValue();
            int outputPowerTotal = regs[18].getValue();
            workinfo.setTempMachine(tempMachine);
            workinfo.setTempEnvironment(tempEnvironment);
            workinfo.setInputVoltagePV(inputVoltagePV);
            workinfo.setInputVoltageBUS(inputVoltageBUS);
            workinfo.setOutputVoltageUV(outputVoltageUV);
            workinfo.setOutputVoltageVW(outputVoltageVW);
            workinfo.setOutputFrequency(outputFrequency);
            workinfo.setOutputCurrentU(outputCurrentU);
            workinfo.setOutputCurrentV(outputCurrentV);
            workinfo.setOutputCurrentW(outputCurrentW);
            workinfo.setOutputVoltageAdjustValueUV(outputVoltageAdjustValueUV);
            workinfo.setOutputVoltageAdjustValueVW(outputVoltageAdjustValueVW);
            workinfo.setOutputCurrentAdjustValueU(outputCurrentAdjustValueU);
            workinfo.setOutputCurrentAdjustValueV(outputCurrentAdjustValueV);
            workinfo.setOutputCurrentAdjustValueW(outputCurrentAdjustValueW);
            workinfo.setOutputPowerW(outputPowerW);
            workinfo.setOutputPowerU(outputPowerU);
            workinfo.setOutputPowerV(outputPowerV);
            workinfo.setOutputPowerTotal(outputPowerTotal);
        }
        if ((regs = handler.readMultipleRegisters(85, 1)) != null && handler.getMachineType().equals("11")) {
            int dC2Voltage = (int)((double)regs[0].getValue() / 10.0);
            workinfo.setDC2Voltage(dC2Voltage);
        }
        return true;
    }

    @Override
    public boolean pollQueryStatus() {
        Register[] regs1;
        ModbusHandler handler;
        block12: {
            try {
                handler = this.getHandler();
                if (handler != null) break block12;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workinfo.setProdid(this._protocol.getProtocolID());
        workinfo.setSerialNo(this._protocol.getSerialNo());
        workinfo.setCurrentTime(new Date());
        Register[] regs = handler.readMultipleRegisters(66, 1);
        if (regs != null) {
            BitVector bits = new BitVector(16);
            bits.setBytes(regs[0].toBytes(), 16);
            bits.toggleAccess(true);
            this.processEvent(bits.getBit(15), "2001", workinfo);
            this.processEvent(bits.getBit(14), "2002", workinfo);
            this.processEvent(bits.getBit(13), "2003", workinfo);
            this.processEvent(bits.getBit(12), "2004", workinfo);
            this.processEvent(bits.getBit(11), "2005", workinfo);
            this.processEvent(bits.getBit(10), "2006", workinfo);
            this.processEvent(bits.getBit(9), "2007", workinfo);
            this.processEvent(bits.getBit(8), "2008", workinfo);
            this.processEvent(bits.getBit(7), "2009", workinfo);
            this.processEvent(bits.getBit(6), "2010", workinfo);
            this.processEvent(bits.getBit(5), "2011", workinfo);
            this.processEvent(bits.getBit(4), "2012", workinfo);
            this.processEvent(bits.getBit(3), "2013", workinfo);
            this.processEvent(bits.getBit(2), "2014", workinfo);
            if (handler.getMachineType().equals("11")) {
                this.processEvent(bits.getBit(1), "2015", workinfo);
                this.processEvent(bits.getBit(0), "2016", workinfo);
            }
        }
        if ((regs1 = handler.readMultipleRegisters(67, 1)) != null && handler.getMachineType().equals("11")) {
            BitVector bits = new BitVector(16);
            bits.setBytes(regs1[0].toBytes(), 16);
            bits.toggleAccess(true);
            this.processEvent(bits.getBit(15), "2017", workinfo);
        }
        if ((regs1 = handler.readMultipleRegisters(64, 1)) != null) {
            int faultCode = regs1[0].getValue();
            if (faultCode != this.oldFaultCode) {
                String eventId = (String)faultMap.get(faultCode);
                if (eventId != null) {
                    this.processEvent(true, eventId, workinfo);
                }
                if ((eventId = (String)faultMap.get(this.oldFaultCode)) != null) {
                    this.processEvent(false, eventId, workinfo);
                }
                this.oldFaultCode = faultCode;
            }
            if (faultCode > 0 && faultCode < 15) {
                workinfo.setHasFault(true);
            } else {
                workinfo.setHasFault(false);
            }
        }
        return true;
    }

    @Override
    public boolean queryMachineInfo() {
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        try {
            MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
            machineInfo.setMachineID(String.valueOf(handler.getMachineID()));
            String serialNo = handler.getSerialNo();
            machineInfo.setSerialNo(serialNo);
            Register[] regs = handler.readMultipleRegisters(55, 1);
            if (regs != null) {
                String bootLoader = new String(regs[0].toBytes()).toString();
                machineInfo.setBootLoader(bootLoader);
                String firmwareVersion = "";
                regs = handler.readMultipleRegisters(56, 4);
                int i = 0;
                while (i < regs.length) {
                    firmwareVersion = String.valueOf(firmwareVersion) + new String(regs[i].toBytes()).toString();
                    ++i;
                }
                machineInfo.setFirmwareVersion(firmwareVersion);
            }
            if ((regs = handler.readMultipleRegisters(1, 4)) != null) {
                int motorRatedPower = regs[0].getValue();
                int motorRatedFrequency = (int)((double)regs[1].getValue() / 100.0);
                double motorRatedVoltage = (double)regs[2].getValue() / 10.0;
                double motorRatedCurrent = (double)regs[3].getValue() / 100.0;
                machineInfo.setRatedOutputCurrent(motorRatedCurrent);
                machineInfo.setRatedOutputFrequency(motorRatedFrequency);
                machineInfo.setRatedOutputPower(motorRatedPower);
                machineInfo.setRatedOutputVoltage(motorRatedVoltage);
            }
            if ((regs = handler.readMultipleRegisters(84, 1)) != null) {
                String machineType = handler.getMachineType();
                String machineTypestr = "";
                if (machineType.equals("1")) {
                    machineTypestr = "2.2KW\u53d8\u9891\u5668";
                } else if (machineType.equals("3")) {
                    machineTypestr = "7.5KW\u53d8\u9891\u5668";
                } else if (machineType.equals("4")) {
                    machineTypestr = "11KW\u53d8\u9891\u5668";
                } else if (machineType.equals("11")) {
                    regs = handler.readMultipleRegisters(25, 1);
                    machineTypestr = regs[0].getValue() == 1111 ? "2.2KW_LS--3" : "2.2KW_LS--1";
                }
                machineInfo.setMachineType(machineTypestr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean queryCapability() {
        ModbusHandler handler = this.getHandler();
        if (handler == null) {
            return false;
        }
        try {
            Register[] regsDRP;
            Capability capability = (Capability)this.getBeanBag().getBean("capability");
            Register[] regs = handler.readMultipleRegisters(22, 2);
            if (regs != null) {
                capability.setMpptFunc(regs[0].getValue() == 1);
                capability.setAutoTurnOn(regs[1].getValue() == 1);
            }
            Register[] regsOut = handler.readMultipleRegisters(24, 1);
            if (regs != null && handler.getMachineType().equals("11")) {
                capability.setIs1Phase2PhaseOutput(regsOut[0].getValue() == 1);
            }
            if ((regsDRP = handler.readMultipleRegisters(60, 1)) != null) {
                capability.setDryRunningProtect(regsDRP[0].getValue() == 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean queryConfigData() {
        ModbusHandler handler;
        block8: {
            try {
                handler = this.getHandler();
                if (handler != null) break block8;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        Register[] regs = handler.readMultipleRegisters(1, 21);
        if (regs != null) {
            int motorRatedPower = regs[0].getValue();
            int motorRatedFrequency = (int)((double)regs[1].getValue() / 100.0);
            double motorRatedVoltage = (double)regs[2].getValue() / 10.0;
            double motorRatedCurrent = (double)regs[3].getValue() / 100.0;
            int maxFrequencyLimit = (int)((double)regs[4].getValue() / 100.0);
            int minFrequencyLimit = (int)((double)regs[5].getValue() / 100.0);
            int maxCurrentLimit = regs[6].getValue();
            int maxCurrentControlKp = regs[7].getValue();
            int maxCurrentControlKi = regs[8].getValue();
            int overLoadProtectionSixtySec = regs[9].getValue();
            int overLoadProtectionOnMotor = regs[10].getValue();
            int voltageForTorqueIncreasing = regs[11].getValue();
            double overDcVoltageProtection = (double)regs[12].getValue() / 10.0;
            double underDcVoltageProtection = (double)regs[13].getValue() / 10.0;
            double pvReferenceVoltage = (double)regs[14].getValue() / 10.0;
            int pvEnergyWeakSleepTime = regs[15].getValue();
            int dryRunningSleepTime = regs[16].getValue();
            int overTemperatureFault = regs[17].getValue();
            int overTemperatureWarning = regs[18].getValue();
            int motorAccelerationTime = regs[19].getValue();
            int motorDecelerationTime = regs[20].getValue();
            if (handler.getMachineType().equals("11")) {
                configdata.setMotorRatedPower(motorRatedPower);
                configdata.setMotorRatedPowerMin(10);
                configdata.setMotorRatedPowerMax(2200);
                configdata.setMotorRatedVoltage(motorRatedVoltage);
                configdata.setMotorRatedVoltageMin(187.0);
                configdata.setMotorRatedVoltageMax(264.0);
                configdata.setOverDcVoltageProtection(overDcVoltageProtection);
                configdata.setUnderDcVoltageProtection(underDcVoltageProtection);
                configdata.setOverDcVoltageProtectionMin(configdata.getUnderDcVoltageProtection());
                configdata.setOverDcVoltageProtectionMax(450.0);
                configdata.setUnderDcVoltageProtectionMin(90.0);
                configdata.setUnderDcVoltageProtectionMax(configdata.getOverDcVoltageProtection());
                configdata.setPvReferenceVoltage(pvReferenceVoltage);
                configdata.setPvReferenceVoltageMin(90.0);
                configdata.setPvReferenceVoltageMax(450.0);
            } else {
                configdata.setMotorRatedPower(motorRatedPower);
                configdata.setMotorRatedPowerMin(10);
                configdata.setMotorRatedPowerMax(11000);
                configdata.setMotorRatedVoltage(motorRatedVoltage);
                configdata.setMotorRatedVoltageMin(323.0);
                configdata.setMotorRatedVoltageMax(506.0);
                configdata.setOverDcVoltageProtection(overDcVoltageProtection);
                configdata.setUnderDcVoltageProtection(underDcVoltageProtection);
                configdata.setOverDcVoltageProtectionMin(configdata.getUnderDcVoltageProtection());
                configdata.setOverDcVoltageProtectionMax(800.0);
                configdata.setUnderDcVoltageProtectionMin(220.0);
                configdata.setUnderDcVoltageProtectionMax(configdata.getOverDcVoltageProtection());
                configdata.setPvReferenceVoltage(pvReferenceVoltage);
                configdata.setPvReferenceVoltageMin(220.0);
                configdata.setPvReferenceVoltageMax(800.0);
            }
            configdata.setMotorRatedFrequency(motorRatedFrequency);
            configdata.setMotorRatedCurrent(motorRatedCurrent);
            configdata.setMotorRatedCurrentMin(0.1);
            configdata.setMotorRatedCurrentMax(60.0);
            configdata.setMaxFrequencyLimit(maxFrequencyLimit);
            configdata.setMaxFrequencyLimitMin(minFrequencyLimit);
            configdata.setMaxFrequencyLimitMax(motorRatedFrequency);
            configdata.setMinFrequencyLimit(minFrequencyLimit);
            configdata.setMinFrequencyLimitMin(6);
            configdata.setMinFrequencyLimitMax(maxFrequencyLimit);
            configdata.setMaxCurrentLimit(maxCurrentLimit);
            configdata.setMaxCurrentLimitMin(10);
            configdata.setMaxCurrentLimitMax(200);
            configdata.setMaxCurrentControlKp(maxCurrentControlKp);
            configdata.setMaxCurrentControlKpMin(50);
            configdata.setMaxCurrentControlKpMax(6000);
            configdata.setMaxCurrentControlKi(maxCurrentControlKi);
            configdata.setMaxCurrentControlKiMin(5);
            configdata.setMaxCurrentControlKiMax(1000);
            configdata.setOverLoadProtectionSixtySec(overLoadProtectionSixtySec);
            configdata.setOverLoadProtectionSixtySecMin(110);
            configdata.setOverLoadProtectionSixtySecMax(250);
            configdata.setOverLoadProtectionOnMotor(overLoadProtectionOnMotor);
            configdata.setOverLoadProtectionOnMotorMin(110);
            configdata.setOverLoadProtectionOnMotorMax(250);
            configdata.setVoltageForTorqueIncreasing(voltageForTorqueIncreasing);
            configdata.setVoltageForTorqueIncreasingMin(0);
            configdata.setVoltageForTorqueIncreasingMax(10);
            configdata.setPvEnergyWeakSleepTime(pvEnergyWeakSleepTime);
            configdata.setPvEnergyWeakSleepTimeMin(10);
            configdata.setPvEnergyWeakSleepTimeMax(3600);
            configdata.setDryRunningSleepTime(dryRunningSleepTime);
            configdata.setDryRunningSleepTimeMin(10);
            configdata.setDryRunningSleepTimeMax(7200);
            configdata.setOverTemperatureFault(overTemperatureFault);
            configdata.setOverTemperatureFaultMin(60);
            configdata.setOverTemperatureFaultMax(100);
            configdata.setOverTemperatureWarning(overTemperatureWarning);
            configdata.setOverTemperatureWarningMin(10);
            configdata.setOverTemperatureWarningMax(100);
            configdata.setMotorAccelerationTime(motorAccelerationTime);
            configdata.setMotorAccelerationTimeMin(1);
            configdata.setMotorAccelerationTimeMax(3600);
            configdata.setMotorDecelerationTime(motorDecelerationTime);
            configdata.setMotorDecelerationTimeMin(1);
            configdata.setMotorDecelerationTimeMax(3600);
        }
        if ((regs = handler.readMultipleRegisters(25, 1)) != null && handler.getMachineType().equals("11")) {
            int Output1Phase3Phase = regs[0].getValue();
            configdata.setOutput1Phase3Phase(Output1Phase3Phase);
            configdata.setOutput1Phase3PhaseMin(0);
            configdata.setOutput1Phase3PhaseMax(1111);
        }
        if ((regs = handler.readMultipleRegisters(83, 1)) != null) {
            int dryRunningPermitTime = regs[0].getValue();
            configdata.setDryRunningPermitTime(dryRunningPermitTime);
            configdata.setDryRunningPermitTimeMin(1);
            configdata.setDryRunningPermitTimeMax(3600);
        }
        return true;
    }

    @Override
    public boolean queryDefaultData() {
        return false;
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }
}

