/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SystemTrayUDPClient {
    private DatagramSocket ds = null;
    private InetAddress inetAddress;
    private static int REV_SIZE = 256;
    private int port;

    public SystemTrayUDPClient(String serverIp, int port) {
        try {
            this.ds = new DatagramSocket();
            this.inetAddress = InetAddress.getByName(serverIp);
            this.port = port;
            this.ds.setSoTimeout(2000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void displayMessage(String caption, String text) {
        try {
            String message = String.valueOf(caption) + "###" + text + "###INFO";
            this.send(message.getBytes("UTF-8"));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public final void send(byte[] bytes) throws IOException {
        DatagramPacket dp = new DatagramPacket(bytes, bytes.length, this.inetAddress, this.port);
        this.ds.send(dp);
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[REV_SIZE];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        return buffer;
    }

    public String receiveString() throws IOException {
        byte[] buffer = new byte[REV_SIZE];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        String info = new String(dp.getData(), 0, dp.getLength());
        return info;
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public void setUpdatedImage(boolean isConnected) {
    }
}

