/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMail {
    private MimeMessage mimeMsg;
    private String username = "";
    private String password = "";
    private int port = 25;
    private Session session;
    private Properties props;
    private Multipart mp;

    public SendMail(String smtp, int port, boolean useTls) {
        this.setSmtpHostPort(smtp, port, useTls);
        this.createMimeMessage();
    }

    public void setSmtpHostPort(String hostName, int port, boolean useTls) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        this.props.put("mail.transport.protocol", "smtp");
        this.props.put("mail.smtp.host", hostName);
        if (port != 0) {
            this.port = port;
        }
        this.props.put("mail.smtp.starttls.enable", String.valueOf(useTls));
    }

    public void createMimeMessage() {
        this.session = Session.getDefaultInstance((Properties)this.props, null);
        this.mimeMsg = new MimeMessage(this.session);
        this.mp = new MimeMultipart();
    }

    public void setNeedAuth(boolean need) {
        if (this.props == null) {
            this.props = System.getProperties();
        }
        if (need) {
            this.props.put("mail.smtp.auth", "true");
        } else {
            this.props.put("mail.smtp.auth", "false");
        }
    }

    public void setNamePass(String name, String pass) {
        this.username = name;
        this.password = pass;
    }

    public void setSubject(String mailSubject) throws MessagingException {
        this.mimeMsg.setSubject(mailSubject);
    }

    public void setBody(String mailBody) throws MessagingException {
        MimeBodyPart bp = new MimeBodyPart();
        bp.setContent((Object)mailBody, "text/html;charset=UTF-8");
        this.mp.addBodyPart((BodyPart)bp);
    }

    public void addFileAffix(String filename) throws MessagingException {
        MimeBodyPart bp = new MimeBodyPart();
        this.mp.addBodyPart((BodyPart)bp);
    }

    public void setFrom(String from) throws AddressException, MessagingException {
        this.mimeMsg.setFrom((Address)new InternetAddress(from));
    }

    public void setTo(String to) throws AddressException, MessagingException {
        if (to == null) {
            throw new MessagingException();
        }
        this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
    }

    public void setCopyTo(String copyto) throws AddressException, MessagingException {
        if (copyto == null) {
            throw new MessagingException();
        }
        this.mimeMsg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)copyto));
    }

    public void sendout() throws MessagingException {
        this.mimeMsg.setContent(this.mp);
        this.mimeMsg.saveChanges();
        Security.addProvider((java.security.Provider)new Provider());
        Session mailSession = Session.getInstance((Properties)this.props, null);
        mailSession.setDebug(true);
        Transport transport = mailSession.getTransport("smtp");
        transport.connect((String)this.props.get("mail.smtp.host"), this.port, this.username, this.password);
        transport.sendMessage((Message)this.mimeMsg, this.mimeMsg.getRecipients(Message.RecipientType.TO));
        transport.close();
    }
}

