/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.configure.EmailConfig;
import cn.com.voltronic.solar.configure.SmsConfig;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.dao.EventCfgDao;
import cn.com.voltronic.solar.data.bean.EventData;
import cn.com.voltronic.solar.data.bean.Eventcfg;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AADefaultTableModel;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.CheckBoxData;
import cn.com.voltronic.solar.view.component.CheckListCellRenderer;
import cn.com.voltronic.solar.view.component.CheckListener;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.dom4j.Element;

public class EventActionDialog
extends AADialog {
    private static final long serialVersionUID = -7387470322905229037L;
    private AAButton jButton1;
    private AAButton jButton2;
    private AACheckBox jCheckBox1;
    private AACheckBox jCheckBox2;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel3;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private AADefaultTableModel tableModel = null;
    private CheckListCellRenderer jList1Renderer = null;
    private CheckListCellRenderer jList2Renderer = null;
    private final int MAX_SIZE = 25;
    private final int MAX_COLUMN = 3;
    private String[] tableTile = new String[]{"ID", "message.level", "message.eventName"};
    private List<EventData> eventlist = new ArrayList<EventData>();
    private String saveEventId;

    public EventActionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.queryEventData();
        this.setTitle("message.electricEventSet");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void queryEventData() {
        String language = "en_US";
        try {
            language = GlobalVariables.globalConfig.getLanguage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        List<Element> list = null;
        String protocol = "P42";
        try {
            protocol = GlobalProcessors.getCurrentProcessor().getProtocol().getProtocolID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (protocol == null || protocol.equals("")) {
            protocol = "P42";
        }
        list = protocol.equals("P42") ? EventsHandler.getP30AllEvent() : EventsHandler.getP30AllEvent();
        EventData data = null;
        for (Element element : list) {
            data = new EventData();
            String id = element.attributeValue("id");
            int level = Integer.parseInt(element.attributeValue("level"));
            String name = null;
            name = language.equals("zh_CN") ? element.attributeValue("name") : (language.equals("fr_FR") ? element.attributeValue("frName") : (language.equals("de_DE") ? element.attributeValue("deName") : (language.equals("it_IT") ? element.attributeValue("itName") : (language.equals("pl_PL") ? element.attributeValue("plName") : (language.equals("pt_PT") ? element.attributeValue("ptName") : (language.equals("ru_RU") ? element.attributeValue("rusName") : (language.equals("es_ES") ? element.attributeValue("spName") : (language.equals("uk_UA") ? element.attributeValue("ukrName") : (language.equals("tr_TR") ? element.attributeValue("turName") : (language.equals("zh_TW") ? element.attributeValue("twName") : element.attributeValue("enName")))))))))));
            data.setEventId(id);
            data.setEventLevel(level);
            data.setEventName(name);
            this.eventlist.add(data);
        }
        int size = this.eventlist.size();
        if (size < 25) {
            size = 25;
        }
        Object[][] obj = new Object[size][3];
        int i = 0;
        while (i < this.eventlist.size()) {
            EventData eventData = this.eventlist.get(i);
            int level = eventData.getEventLevel();
            String levelStr = "";
            if (level == 1) {
                levelStr = "message.fault";
            } else if (level == 2) {
                levelStr = "message.warning";
            } else if (level == 3) {
                levelStr = "message.info";
            }
            obj[i][0] = eventData.getEventId();
            obj[i][1] = levelStr;
            obj[i][2] = eventData.getEventName();
            ++i;
        }
        if (this.eventlist.size() < 25) {
            i = this.eventlist.size();
            while (i < 25) {
                int j = 0;
                while (j < 3) {
                    obj[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.tableModel.setDataVector(obj, this.tableTile);
        this.setTableFormate();
        this.jSplitPane1.setDividerLocation(0.5);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane4 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new AALabel();
        this.jCheckBox1 = new AACheckBox();
        this.jCheckBox2 = new AACheckBox();
        this.jLabel2 = new AALabel();
        this.jScrollPane2 = new JScrollPane();
        this.jLabel3 = new AALabel();
        this.jScrollPane3 = new JScrollPane();
        this.jButton1 = new AAButton();
        this.jButton2 = new AAButton();
        EmailConfig emailInfo = GlobalVariables.emailConfig;
        String recievers = emailInfo.getRecievers().trim();
        String[] reArr = new String[]{};
        if (!"".equalsIgnoreCase(recievers)) {
            reArr = recievers.split(";");
        }
        CheckBoxData[] datas = new CheckBoxData[reArr.length];
        int i = 0;
        while (i < reArr.length) {
            datas[i] = new CheckBoxData(reArr[i], false, true);
            ++i;
        }
        this.jList1 = new JList<CheckBoxData>(datas);
        this.jList1Renderer = new CheckListCellRenderer();
        this.jList1Renderer.setEnabled(false);
        this.jList1.setCellRenderer(this.jList1Renderer);
        this.jList1.setSelectionMode(0);
        CheckListener lst = new CheckListener(this.jList1);
        this.jList1.addMouseListener(lst);
        this.jList1.addKeyListener(lst);
        this.jList1.setEnabled(false);
        SmsConfig smsInfo = GlobalVariables.smsConfig;
        if (smsInfo == null) {
            smsInfo = new SmsConfig();
        }
        String mobileNum = smsInfo.getMobileNums().trim();
        String[] mnArr = new String[]{};
        if (!"".equalsIgnoreCase(mobileNum)) {
            mnArr = mobileNum.split(";");
        }
        CheckBoxData[] datas2 = new CheckBoxData[mnArr.length];
        int i2 = 0;
        while (i2 < mnArr.length) {
            datas2[i2] = new CheckBoxData(mnArr[i2], false, true);
            ++i2;
        }
        this.jList2 = new JList<CheckBoxData>(datas2);
        this.jList2Renderer = new CheckListCellRenderer();
        this.jList2Renderer.setEnabled(false);
        this.jList2.setCellRenderer(this.jList2Renderer);
        this.jList2.setSelectionMode(0);
        CheckListener lst2 = new CheckListener(this.jList2);
        this.jList2.addMouseListener(lst2);
        this.jList2.addKeyListener(lst2);
        this.jList2.setEnabled(false);
        this.jTable1 = new JTable(){
            private static final long serialVersionUID = -2097364819095589911L;

            @Override
            public boolean isCellSelected(int row, int column) {
                if (row >= EventActionDialog.this.eventlist.size()) {
                    return false;
                }
                return super.isCellSelected(row, column);
            }
        };
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().setForeground(Color.white);
        this.jTable1.setSelectionMode(0);
        this.setDefaultCloseOperation(2);
        this.tableModel = new AADefaultTableModel(new Object[25][3], this.tableTile){
            private static final long serialVersionUID = -6182498251644323805L;

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.jTable1.setModel(this.tableModel);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EventActionDialog.this.mouseClickedTable(e);
            }
        });
        this.setTableFormate();
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jLabel1.setText("message.response[:]");
        this.jCheckBox1.setText("message.recordMethod");
        this.jCheckBox1.setEnabled(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventActionDialog.this.jButton2.setEnabled(true);
            }
        });
        this.jCheckBox2.setText("message.warningMessage");
        this.jCheckBox2.setEnabled(false);
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventActionDialog.this.jButton2.setEnabled(true);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EventActionDialog.this.jList1Renderer.isEnabled()) {
                    EventActionDialog.this.jButton2.setEnabled(true);
                }
            }
        });
        this.jList2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EventActionDialog.this.jList2Renderer.isEnabled()) {
                    EventActionDialog.this.jButton2.setEnabled(true);
                }
            }
        });
        this.jLabel2.setText("message.receivemail");
        this.jScrollPane2.setViewportView(this.jList1);
        this.jLabel3.setText("message.receivesms");
        this.jScrollPane3.setViewportView(this.jList2);
        this.jButton1.setText("message.close");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventActionDialog.this.dispose();
            }
        });
        this.jButton2.setText("message.apply");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                EventActionDialog.this.saveEventAction(e);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 210, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2, GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1, GroupLayout.Alignment.LEADING)).addContainerGap(77, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(206, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(31, 31, 31).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 58, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1)).addGap(19, 19, 19)));
        this.jScrollPane4.setViewportView(this.jPanel1);
        this.jSplitPane1.setRightComponent(this.jScrollPane4);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    public void mouseClickedTable(MouseEvent e) {
        int row = this.jTable1.getSelectedRow();
        Object obj = this.jTable1.getValueAt(row, 0);
        if (obj != null) {
            this.jCheckBox1.setEnabled(true);
            this.jCheckBox2.setEnabled(true);
            this.jList1.setEnabled(true);
            this.jList1Renderer.setEnabled(true);
            this.jList2.setEnabled(true);
            this.jList2Renderer.setEnabled(true);
            this.jButton2.setEnabled(true);
            this.jCheckBox1.setSelected(false);
            this.jCheckBox2.setSelected(false);
            CheckBoxData[] listDataDefault = new CheckBoxData[this.jList1.getModel().getSize()];
            int j = 0;
            while (j < this.jList1.getModel().getSize()) {
                CheckBoxData checkBoxData = (CheckBoxData)this.jList1.getModel().getElementAt(j);
                checkBoxData.setSelected(false);
                listDataDefault[j] = checkBoxData;
                ++j;
            }
            this.jList1.setListData(listDataDefault);
            CheckBoxData[] listDataDefault2 = new CheckBoxData[this.jList2.getModel().getSize()];
            int j2 = 0;
            while (j2 < this.jList2.getModel().getSize()) {
                CheckBoxData checkBoxData = (CheckBoxData)this.jList2.getModel().getElementAt(j2);
                checkBoxData.setSelected(false);
                listDataDefault2[j2] = checkBoxData;
                ++j2;
            }
            this.jList2.setListData(listDataDefault2);
            this.saveEventId = obj.toString().trim();
            EventCfgDao eventCfgDao = new EventCfgDao();
            List<Eventcfg> eventCfgList = eventCfgDao.queryEventcfg(this.saveEventId);
            int i = 0;
            while (i < eventCfgList.size()) {
                CheckBoxData checkBoxData;
                int j3;
                CheckBoxData[] listData;
                Eventcfg cfg = eventCfgList.get(i);
                if (cfg.getAction() == 1) {
                    this.jCheckBox1.setSelected(true);
                } else if (cfg.getAction() == 2) {
                    this.jCheckBox2.setSelected(true);
                } else if (cfg.getAction() == 3) {
                    listData = new CheckBoxData[this.jList1.getModel().getSize()];
                    j3 = 0;
                    while (j3 < this.jList1.getModel().getSize()) {
                        checkBoxData = (CheckBoxData)this.jList1.getModel().getElementAt(j3);
                        if (cfg.getReceive().equals(checkBoxData.getName())) {
                            checkBoxData.setSelected(true);
                        }
                        listData[j3] = checkBoxData;
                        ++j3;
                    }
                    this.jList1.setListData(listData);
                } else if (cfg.getAction() == 4) {
                    listData = new CheckBoxData[this.jList2.getModel().getSize()];
                    j3 = 0;
                    while (j3 < this.jList2.getModel().getSize()) {
                        checkBoxData = (CheckBoxData)this.jList2.getModel().getElementAt(j3);
                        if (cfg.getReceive().equals(checkBoxData.getName())) {
                            checkBoxData.setSelected(true);
                        }
                        listData[j3] = checkBoxData;
                        ++j3;
                    }
                    this.jList2.setListData(listData);
                }
                ++i;
            }
        }
    }

    public void saveEventAction(ActionEvent e) {
        boolean hasCfg = false;
        if (this.saveEventId != null && !"".equalsIgnoreCase(this.saveEventId)) {
            Eventcfg eventCfg;
            CheckBoxData checkBoxData;
            Eventcfg eventCfg2;
            this.jButton2.setEnabled(false);
            EventCfgDao eventCfgDao = new EventCfgDao();
            eventCfgDao.removeEventcfg(this.saveEventId);
            if (this.jCheckBox1.isSelected()) {
                eventCfg2 = new Eventcfg();
                eventCfg2.setAction(1);
                eventCfg2.setEventid(this.saveEventId);
                eventCfg2.setReceive(null);
                eventCfgDao.insertCfg(eventCfg2);
                hasCfg = true;
            }
            if (this.jCheckBox2.isSelected()) {
                eventCfg2 = new Eventcfg();
                eventCfg2.setAction(2);
                eventCfg2.setEventid(this.saveEventId);
                eventCfg2.setReceive(null);
                eventCfgDao.insertCfg(eventCfg2);
                hasCfg = true;
            }
            int i = 0;
            while (i < this.jList1.getModel().getSize()) {
                checkBoxData = (CheckBoxData)this.jList1.getModel().getElementAt(i);
                if (checkBoxData.isSelected()) {
                    eventCfg = new Eventcfg();
                    eventCfg.setAction(3);
                    eventCfg.setEventid(this.saveEventId);
                    eventCfg.setReceive(checkBoxData.getName());
                    eventCfgDao.insertCfg(eventCfg);
                    hasCfg = true;
                }
                ++i;
            }
            int j = 0;
            while (j < this.jList2.getModel().getSize()) {
                checkBoxData = (CheckBoxData)this.jList2.getModel().getElementAt(j);
                if (checkBoxData.isSelected()) {
                    eventCfg = new Eventcfg();
                    eventCfg.setAction(4);
                    eventCfg.setEventid(this.saveEventId);
                    eventCfg.setReceive(checkBoxData.getName());
                    eventCfgDao.insertCfg(eventCfg);
                    hasCfg = true;
                }
                ++j;
            }
            if (!hasCfg) {
                Eventcfg eventCfg3 = new Eventcfg();
                eventCfg3.setAction(0);
                eventCfg3.setEventid(this.saveEventId);
                eventCfg3.setReceive(null);
                eventCfgDao.insertCfg(eventCfg3);
            }
        } else {
            DisplayMessage.showWarningDialog("message.noselect");
        }
    }

    public void setTableFormate() {
        TableColumnModel tcm = this.jTable1.getColumnModel();
        TableColumn tc0 = tcm.getColumn(0);
        TableColumn tc1 = tcm.getColumn(1);
        TableColumn tc2 = tcm.getColumn(2);
        tc0.setPreferredWidth(30);
        tc1.setPreferredWidth(40);
        tc2.setPreferredWidth(250);
    }
}

