/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.component;

import cn.com.voltronic.solar.view.component.CheckBoxData;
import cn.com.voltronic.solar.view.component.ComboCheckBoxEntry;
import cn.com.voltronic.solar.view.component.ComboCheckBoxRenderer;
import cn.com.voltronic.solar.view.component.ComboCheckBoxUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JComboCheckBox
extends JComboBox {
    private static final long serialVersionUID = 4376982506265668003L;
    private int maxWidth = 300;

    public JComboCheckBox() {
        this.setRenderer(new ComboCheckBoxRenderer());
        this.updateUI();
    }

    public JComboCheckBox(String[] items) {
        this.setRenderer(new ComboCheckBoxRenderer());
        this.addItems(items);
        this.updateUI();
    }

    public JComboCheckBox(Vector<String> items) {
        this.setRenderer(new ComboCheckBoxRenderer());
        this.addItems(items.toArray(new String[0]));
        this.updateUI();
    }

    public JComboCheckBox(int maxWidth) {
        this.maxWidth = maxWidth;
        this.setRenderer(new ComboCheckBoxRenderer());
        this.updateUI();
    }

    public JComboCheckBox(String[] items, int maxWidth) {
        this.maxWidth = maxWidth;
        this.setRenderer(new ComboCheckBoxRenderer());
        this.addItems(items);
        this.updateUI();
    }

    public JComboCheckBox(Vector<String> items, int maxWidth) {
        this.maxWidth = maxWidth;
        this.setRenderer(new ComboCheckBoxRenderer());
        this.addItems(items.toArray(new String[0]));
        this.updateUI();
    }

    public void addItems(String[] items) {
        int i = 0;
        while (i < items.length) {
            String string = items[i];
            this.addItem(new ComboCheckBoxEntry(String.valueOf(i + 1), string));
            ++i;
        }
    }

    public void addItems(List<CheckBoxData> items) {
        int i = 0;
        while (i < items.size()) {
            String value = items.get(i).getName();
            boolean check = items.get(i).isSelected();
            boolean enable = items.get(i).isEnable();
            this.addItem(new ComboCheckBoxEntry(check, enable, String.valueOf(i + 1), value));
            ++i;
        }
    }

    public void addItem(ComboCheckBoxEntry item) {
        super.addItem(item);
    }

    public void addItem(boolean checked, boolean state, String id, String value) {
        super.addItem(new ComboCheckBoxEntry(checked, state, id, value));
    }

    public String[] getCheckedCodes() {
        Vector<String> values = new Vector<String>();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        int i = 0;
        while (i < model.getSize()) {
            ComboCheckBoxEntry item = (ComboCheckBoxEntry)model.getElementAt(i);
            boolean checked = item.isChecked();
            if (checked) {
                values.add(item.getUniqueCode());
            }
            ++i;
        }
        Object[] retVal = new String[values.size()];
        values.copyInto(retVal);
        return retVal;
    }

    public String[] getCheckedValues() {
        Vector<String> values = new Vector<String>();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        int i = 0;
        while (i < model.getSize()) {
            ComboCheckBoxEntry item = (ComboCheckBoxEntry)model.getElementAt(i);
            boolean checked = item.isChecked();
            if (checked) {
                values.add(item.getValue());
            }
            ++i;
        }
        Object[] retVal = new String[values.size()];
        values.copyInto(retVal);
        return retVal;
    }

    public List<String> getCheckedLabels() {
        ArrayList<String> retVal = new ArrayList<String>();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        int i = 0;
        while (i < model.getSize()) {
            ComboCheckBoxEntry item = (ComboCheckBoxEntry)model.getElementAt(i);
            if (item.isChecked()) {
                retVal.add(item.getValue());
            }
            ++i;
        }
        return retVal;
    }

    public List<CheckBoxData> getCheckBoxDatas() {
        ArrayList<CheckBoxData> retVal = new ArrayList<CheckBoxData>();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        int i = 0;
        while (i < model.getSize()) {
            ComboCheckBoxEntry item = (ComboCheckBoxEntry)model.getElementAt(i);
            CheckBoxData data = new CheckBoxData();
            data.setName(item.getValue());
            data.setSelected(item.isChecked());
            data.setEnable(item.isEnable());
            retVal.add(data);
            ++i;
        }
        return retVal;
    }

    @Override
    public void updateUI() {
        this.setUI(new ComboCheckBoxUI(this.maxWidth));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(650, 580);
        frame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        String[] values = new String[]{"1111111111111111111", "22", "33333333333333333333", "4444444444444", "55555555555555555", "6", "77", "6", "77", "6", "77"};
        JComboCheckBox checkBox = new JComboCheckBox(values);
        checkBox.setPreferredSize(new Dimension(150, 30));
        jPanel.add(checkBox);
        JButton btnCode = new JButton("Code");
        btnCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] stringArray = JComboCheckBox.this.getCheckedCodes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    System.out.print(String.valueOf(string) + " ");
                    ++n2;
                }
                System.out.println("");
            }
        });
        jPanel.add(btnCode);
        JButton btnValue = new JButton("Value");
        btnValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] stringArray = JComboCheckBox.this.getCheckedValues();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    System.out.print(String.valueOf(string) + " ");
                    ++n2;
                }
                System.out.println("");
            }
        });
        jPanel.add(btnValue);
        frame.getContentPane().add(jPanel);
        frame.setVisible(true);
    }
}

