/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.ModbusHandlerMaster;
import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.system.ProcessorCategories;
import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class SearchDevice
extends Thread {
    protected static final Logger logger = Logger.getLogger(SearchDevice.class);
    private int currentLinkCount;
    private int oldLinkCount;
    private static final int MAX_WAIT_TIME = 4000;
    private static final int MID_WAIT_TIME = 1000;
    private static final int MIN_WAIT_TIME = 500;
    private ArrayList<AbstractProcessor> templist = new ArrayList();

    @Override
    public void run() {
        int time_i = 0;
        while (!SystemEnv.stopping) {
            if (time_i >= GlobalVariables.globalConfig.getDeviceSacanInterval()) {
                this.searchLocalComs();
                time_i = 0;
                this.sendToTray();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++time_i;
        }
        ++SystemEnv.stoped;
    }

    public void sendToTray() {
        int status = this.getLinkCount();
        UdpClient udpClient = null;
        if (status == 1) {
            try {
                try {
                    String port = "38694";
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (port != null && !"".equals(port)) {
                        udpClient = new UdpClient("localhost", port);
                        udpClient.send("(PVCount:" + this.currentLinkCount);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (udpClient != null) {
                        udpClient.disconnect();
                    }
                }
            }
            finally {
                if (udpClient != null) {
                    udpClient.disconnect();
                }
            }
        }
    }

    public int getLinkCount() {
        this.currentLinkCount = GlobalProcessors.getProcesserSize();
        if (this.oldLinkCount != this.currentLinkCount) {
            this.oldLinkCount = this.currentLinkCount;
            return 1;
        }
        return -1;
    }

    public void searchLocalComs() {
        Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
        while (portEn.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
            if (portId.getPortType() != 1) continue;
            Object handler = GlobalProcessors.getUsedHandlerbyName(portId.getName());
            if (!GlobalVariables.globalConfig.isUseModbus() || !ModbusHandlerMaster.isUseCom(portId) || GlobalProcessors.getExcludeComs().contains(portId.getName())) continue;
            if (handler == null) {
                this.searchModbus(portId);
                continue;
            }
            if (!(handler instanceof ModbusHandler)) continue;
            this.searchModbus(((ModbusHandler)handler).getMaster());
        }
    }

    private void searchModbus(CommPortIdentifier portId) {
        try {
            ModbusHandlerMaster handlerMaster = new ModbusHandlerMaster(portId);
            this.searchModbus(handlerMaster);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void searchModbus(ModbusHandlerMaster handlerMaster) {
        handlerMaster.generateHandlers();
        handlers = handlerMaster.getHandlers();
        closeHandlers = new ArrayList<ModbusHandler>();
        this.templist.clear();
        previoushandlersize = oldActivehandlersize = handlerMaster.getActiveHandlesSize();
        scanNumber = allhandlesize = handlers.size();
        sleeptime = 0;
        scanCount = 0;
        this.setPriority(10);
        item = 0;
        while (item < allhandlesize) {
            block21: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                if (SystemEnv.stopping) break;
                                handler = handlers.get(item);
                                if (handler == null || handler.isActive()) break block21;
                                if (!handler.isMustClose()) break block22;
                                closeHandlers.add(handler);
                                break block21;
                            }
                            if (oldActivehandlersize != 0) break block23;
                            scanNumber = allhandlesize;
                            sleeptime = 10;
                            ** GOTO lbl52
                        }
                        if (!handlerMaster.maybeLost()) break block24;
                        scanNumber = 1;
                        sleeptime = 4000;
                        ** GOTO lbl52
                    }
                    if (handlerMaster.getActiveHandlesSize() <= previoushandlersize) break block25;
                    previoushandlersize = handlerMaster.getActiveHandlesSize();
                    scanNumber = (allhandlesize - previoushandlersize) / 2;
                    if (scanNumber < 40) {
                        scanNumber = 40;
                    }
                    sleeptime = 500;
                    ** GOTO lbl52
                }
                if (oldActivehandlersize > 0 && handlerMaster.getActiveHandlesSize() == 0) {
                    closeHandlers.add(handler);
                } else {
                    if (allhandlesize > oldActivehandlersize * 4) {
                        if (oldActivehandlersize <= 20) {
                            scanNumber = 20;
                            sleeptime = 1000;
                        } else {
                            scanNumber = oldActivehandlersize;
                            sleeptime = 1000;
                        }
                    } else {
                        scanNumber = 10;
                        sleeptime = 500;
                    }
lbl52:
                    // 6 sources

                    processor = ProcessorCategories.getNewMonitor(handler);
                    if (processor != null && !processor.isClosing() && handler != null) {
                        processor.setDeviceName(handler.getDeviceName());
                        handler.setActive(true);
                        this.doProcessor(processor);
                    } else if (handler != null) {
                        closeHandlers.add(handler);
                    }
                    if (++scanCount > scanNumber) {
                        try {
                            for (AbstractProcessor process : this.templist) {
                                try {
                                    process.startMonitor();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            this.templist.clear();
                            SearchDevice.sleep(sleeptime);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        scanCount = 0;
                        previoushandlersize = oldActivehandlersize = handlerMaster.getActiveHandlesSize();
                    }
                }
            }
            ++item;
        }
        for (ModbusHandler item : closeHandlers) {
            if (item == null) continue;
            item.close();
        }
        for (AbstractProcessor process : this.templist) {
            try {
                process.startMonitor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setPriority(5);
    }

    private void doProcessor(AbstractProcessor processer) {
        if (GlobalProcessors.findProcessor(processer.processorKey()) == null) {
            GlobalProcessors.addProcessor(processer.processorKey(), processer);
            this.templist.add(processer);
        }
    }
}

