/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.cmd;

import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.facade.ModbusSerialMaster;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.util.BitVector;
import net.wimpi.modbus.util.ModbusUtil;
import net.wimpi.modbus.util.SerialParameters;

public class SerialFacadeTest {
    public static void main(String[] args) {
        int inChar = -1;
        int result = 0;
        boolean finished = false;
        int slaveId = 88;
        String portname = null;
        ModbusSerialMaster msm = null;
        try {
            if (args.length < 2) {
                SerialFacadeTest.printUsage();
                System.exit(1);
            } else {
                try {
                    portname = args[0];
                    slaveId = Integer.parseInt(args[1]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    SerialFacadeTest.printUsage();
                    System.exit(1);
                }
            }
            System.out.println(" sending test messages to slave: " + slaveId);
            System.out.println("net.wimpi.modbus.debug set to: " + System.getProperty("net.wimpi.modbus.debug"));
            System.out.println("Hit enter to start and <s enter> to terminate the test.");
            inChar = System.in.read();
            if (inChar == 115 || inChar == 83) {
                System.out.println("Exiting");
                System.exit(0);
            }
            SerialParameters params = new SerialParameters();
            params.setPortName(portname);
            params.setBaudRate(38400);
            params.setDatabits(8);
            params.setParity("None");
            params.setStopbits(1);
            params.setEncoding("rtu");
            params.setEcho(true);
            if (Modbus.debug) {
                System.out.println("Encoding [" + params.getEncoding() + "]");
            }
            msm = new ModbusSerialMaster(params);
            msm.connect();
            do {
                int n;
                if (msm.writeCoil(slaveId, 4, true)) {
                    System.out.println("Set output 5 to true");
                } else {
                    System.err.println("Error setting slave " + slaveId + " output 5");
                }
                BitVector coils = msm.readCoils(slaveId, 0, 8);
                if (coils != null) {
                    System.out.print("Coils:");
                    int i = 0;
                    while (i < coils.size()) {
                        System.out.print(" " + i + ": " + coils.getBit(i));
                        ++i;
                    }
                    System.out.println();
                    try {
                        msm.writeMultipleCoils(slaveId, 0, coils);
                    }
                    catch (ModbusException ex) {
                        System.out.println("Error writing coils: " + result);
                    }
                } else {
                    System.out.println("Outputs: null");
                    msm.disconnect();
                    System.exit(-1);
                }
                BitVector digInp = msm.readInputDiscretes(slaveId, 0, 8);
                if (digInp != null) {
                    System.out.print("Digital Inputs:");
                    int i = 0;
                    while (i < digInp.size()) {
                        System.out.print(" " + i + ": " + digInp.getBit(i));
                        ++i;
                    }
                    System.out.println();
                    System.out.println("Inputs: " + ModbusUtil.toHex(digInp.getBytes()));
                } else {
                    System.out.println("Inputs: null");
                    msm.disconnect();
                    System.exit(-1);
                }
                InputRegister[] ai = null;
                int i = 1000;
                while (i < 1010) {
                    ai = msm.readInputRegisters(slaveId, i, 1);
                    if (ai != null) {
                        System.out.print("Tag " + i + ": ");
                        n = 0;
                        while (n < ai.length) {
                            System.out.print(" " + ai[n].getValue());
                            ++n;
                        }
                        System.out.println();
                    } else {
                        System.out.println("Tag: " + i + " null");
                        msm.disconnect();
                        System.exit(-1);
                    }
                    ++i;
                }
                Register[] regs = null;
                int i2 = 1000;
                while (i2 < 1005) {
                    regs = msm.readMultipleRegisters(slaveId, i2, 1);
                    if (regs != null) {
                        System.out.print("RWRegisters " + i2 + " length: " + regs.length);
                        int n2 = 0;
                        while (n2 < regs.length) {
                            System.out.print(" " + regs[n2].getValue());
                            ++n2;
                        }
                        System.out.println();
                    } else {
                        System.out.println("RWRegisters " + i2 + ": null");
                        msm.disconnect();
                        System.exit(-1);
                    }
                    ++i2;
                }
                regs = msm.readMultipleRegisters(slaveId, 0, 10);
                System.out.println("Registers: ");
                if (regs != null) {
                    System.out.print("regs :");
                    n = 0;
                    while (n < regs.length) {
                        System.out.print("  " + n + "= " + regs[n]);
                        ++n;
                    }
                    System.out.println();
                } else {
                    System.out.println("Registers: null");
                    msm.disconnect();
                    System.exit(-1);
                }
                while (System.in.available() > 0) {
                    inChar = System.in.read();
                    if (inChar != 115 && inChar != 83) continue;
                    finished = true;
                }
            } while (!finished);
        }
        catch (Exception e) {
            System.err.println("SerialFacadeTest driver: " + e);
            e.printStackTrace();
        }
        msm.disconnect();
    }

    private static void printUsage() {
        System.out.println("java net.wimpi.modbus.cmd.SerialAITest <portname [String]>  <Unit Address [int8]>");
    }
}

