/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.net.TCPConnectionHandler;
import net.wimpi.modbus.net.TCPSlaveConnection;
import net.wimpi.modbus.util.ThreadPool;

public class ModbusTCPListener
implements Runnable {
    private static int c_RequestCounter = 0;
    private ServerSocket m_ServerSocket = null;
    private ThreadPool m_ThreadPool;
    private Thread m_Listener;
    private int m_Port = 502;
    private int m_FloodProtection = 5;
    private boolean m_Listening;
    private InetAddress m_Address;
    private static final int REQUESTS_TOGC = 10;

    public ModbusTCPListener(int poolsize) {
        this.m_ThreadPool = new ThreadPool(poolsize);
        try {
            this.m_Address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public ModbusTCPListener(int poolsize, InetAddress addr) {
        this.m_ThreadPool = new ThreadPool(poolsize);
        this.m_Address = addr;
    }

    public void setPort(int port) {
        this.m_Port = port;
    }

    public void setAddress(InetAddress addr) {
        this.m_Address = addr;
    }

    public void start() {
        this.m_Listener = new Thread(this);
        this.m_Listener.start();
        this.m_Listening = true;
    }

    public void stop() {
        this.m_Listening = false;
        try {
            this.m_ServerSocket.close();
            this.m_Listener.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection, this.m_Address);
            if (Modbus.debug) {
                System.out.println("Listenening to " + this.m_ServerSocket.toString() + "(Port " + this.m_Port + ")");
            }
            do {
                Socket incoming = this.m_ServerSocket.accept();
                if (Modbus.debug) {
                    System.out.println("Making new connection " + incoming.toString());
                }
                if (this.m_Listening) {
                    this.m_ThreadPool.execute(new TCPConnectionHandler(new TCPSlaveConnection(incoming)));
                    this.count();
                    continue;
                }
                incoming.close();
            } while (this.m_Listening);
        }
        catch (SocketException iex) {
            if (!this.m_Listening) {
                return;
            }
            iex.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    private void count() {
        if (++c_RequestCounter == 10) {
            System.gc();
            c_RequestCounter = 0;
        }
    }
}

