/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.mac.MacPasteboard;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacSystemClipboard
extends SystemClipboard {
    static final String FILE_SCHEME = "file";
    private static final String BAD_URI_MSG = "bad URI in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    private static final String BAD_URL_MSG = "bad URL in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    static final boolean SUPPORT_10_5_API = true;
    static final boolean SUPPORT_10_5_API_FORCE = false;
    static final boolean SUPPORT_10_6_API = false;
    long seed = 0L;
    final MacPasteboard pasteboard;
    private static HashMap utm = null;
    private static HashMap mtu = null;

    public MacSystemClipboard(String string) {
        super(string);
        this.pasteboard = string.equals("DND") ? new MacPasteboard(2) : (string.equals("SYSTEM") ? new MacPasteboard(1) : new MacPasteboard(string));
    }

    @Override
    protected boolean isOwner() {
        return this.seed == this.pasteboard.getSeed();
    }

    @Override
    protected int supportedSourceActionsFromSystem() {
        return this.pasteboard.getAllowedOperation();
    }

    @Override
    protected void pushTargetActionToSystem(int n) {
    }

    @Override
    protected void pushToSystem(HashMap<String, Object> hashMap, int n) {
        String[] stringArray;
        HashMap<String, String[]> hashMap2 = null;
        HashMap[] hashMapArray = null;
        Set<String> set = hashMap.keySet();
        for (String object : set) {
            Object object2;
            int string;
            Object i;
            Object object3 = hashMap.get(object);
            if (object3 == null) continue;
            if (object.equals("text/uri-list")) {
                int uRI;
                stringArray = (String)object3;
                i = stringArray.split("\n");
                string = 0;
                for (uRI = 0; uRI < ((String[])i).length; ++uRI) {
                    object2 = i[uRI];
                    if (((String)object2).startsWith("#")) continue;
                    ++string;
                }
                if (string <= 0) continue;
                hashMapArray = new HashMap[string];
                string = 0;
                for (uRI = 0; uRI < ((String[])i).length; ++uRI) {
                    object2 = i[uRI];
                    if (((String)object2).startsWith("#")) continue;
                    URI uRI2 = this.createUri((String)object2, BAD_URI_MSG);
                    String string2 = "public.url";
                    if (uRI2.getScheme() == null) {
                        string2 = "public.file-url";
                        uRI2 = this.createUri(FILE_SCHEME, uRI2.getPath(), BAD_URI_MSG);
                    }
                    hashMapArray[string] = new HashMap();
                    hashMapArray[string].put(string2, uRI2.toASCIIString());
                    ++string;
                }
                continue;
            }
            if (object.equals("application/x-java-rawimage")) {
                stringArray = (Pixels)object3;
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, String[]>();
                }
                hashMap2.put(this.mimeToUtf(object), stringArray);
                continue;
            }
            if (object.equals("text/plain") || object.equals("text/html") || object.equals("text/rtf")) {
                if (object3 instanceof String) {
                    stringArray = (String)object3;
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                    }
                    hashMap2.put(this.mimeToUtf(object), stringArray);
                    continue;
                }
                System.err.println("DelayedCallback not implemented yet: RT-14593");
                Thread.dumpStack();
                continue;
            }
            if (object.equals("application/x-java-file-list")) {
                stringArray = (String[])object3;
                if (hashMap.get("text/uri-list") == null) {
                    hashMapArray = new HashMap[stringArray.length];
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = stringArray[j];
                        URI string4 = this.createUri(string3, BAD_URI_MSG);
                        object2 = "public.url";
                        if (string4.getScheme() == null) {
                            object2 = "public.file-url";
                            string4 = this.createUri(FILE_SCHEME, string4.getPath(), BAD_URI_MSG);
                        }
                        hashMapArray[j] = new HashMap();
                        hashMapArray[j].put(object2, string4.toASCIIString());
                    }
                    continue;
                }
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                }
                i = null;
                for (string = 0; string < stringArray.length; ++string) {
                    String string5 = stringArray[string];
                    object2 = this.createUri(string5, BAD_URI_MSG);
                    if (i == null) {
                        i = new StringBuilder();
                    }
                    ((StringBuilder)i).append(((URI)object2).getPath());
                    if (string >= stringArray.length - 1) continue;
                    ((StringBuilder)i).append("\n");
                }
                if (i == null || hashMap2.get("public.utf8-plain-text") != null) continue;
                hashMap2.remove("public.utf8-plain-text");
                hashMap2.put("public.utf8-plain-text", (String[])((StringBuilder)i).toString());
                continue;
            }
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            hashMap2.put(this.mimeToUtf(object), (String[])this.serialize(object3));
        }
        if (hashMap2 != null) {
            if (hashMapArray == null) {
                hashMapArray = new HashMap[]{hashMap2};
            } else {
                HashMap hashMap3 = hashMapArray[0];
                hashMapArray[0] = hashMap2;
                for (Object object3 : hashMap3.keySet()) {
                    stringArray = hashMap3.get(object3);
                    hashMapArray[0].put(object3, stringArray);
                }
            }
        }
        if (hashMapArray != null) {
            this.seed = this.pasteboard.putItems(hashMapArray, n);
        }
    }

    @Override
    protected Object popFromSystem(String string) {
        Object object = null;
        String[][] stringArray = this.pasteboard.getUTFs();
        if (string.equals("text/uri-list")) {
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = this.pasteboard.getItemStringForUTF(i, this.mimeToUtf("text/uri-list"));
                    if (string2 == null) continue;
                    arrayList.add(string2);
                    break;
                }
                if (arrayList.size() > 0) {
                    object = arrayList.get(0);
                }
            }
        } else if (string.equals("application/x-java-rawimage")) {
            if (stringArray != null) {
                ArrayList<Pixels> arrayList = new ArrayList<Pixels>();
                for (int i = 0; i < stringArray.length; ++i) {
                    byte[] byArray = this.pasteboard.getItemAsRawImage(i);
                    if (byArray == null) continue;
                    Pixels pixels = this.getPixelsForRawImage(byArray);
                    arrayList.add(pixels);
                    break;
                }
                if (arrayList.size() > 0) {
                    object = arrayList.get(0);
                }
            }
        } else if (string.equals("text/plain") || string.equals("text/html") || string.equals("text/rtf")) {
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = this.pasteboard.getItemStringForUTF(i, this.mimeToUtf(string));
                    if (string3 == null) continue;
                    arrayList.add(string3);
                    break;
                }
                if (arrayList.size() > 0) {
                    object = arrayList.get(0);
                }
            }
        } else if (string.equals("application/x-java-file-list")) {
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = this.pasteboard.getItemStringForUTF(i, "public.file-url");
                    if (string4 == null) continue;
                    URL uRL = this.createUrl(string4, BAD_URL_MSG);
                    arrayList.add(uRL.getPath());
                }
                if (arrayList.size() > 0) {
                    object = new String[arrayList.size()];
                    arrayList.toArray((T[])object);
                }
            }
        } else if (stringArray != null) {
            ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
            for (int i = 0; i < stringArray.length; ++i) {
                byte[] byArray = this.pasteboard.getItemBytesForUTF(i, this.mimeToUtf(string));
                if (byArray == null) continue;
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                arrayList.add(byteBuffer);
                break;
            }
            if (arrayList.size() > 0) {
                object = arrayList.get(0);
            }
        }
        return object;
    }

    @Override
    protected String[] mimesFromSystem() {
        String[][] stringArray = this.pasteboard.getUTFs();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                if (stringArray2 == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string = stringArray2[j];
                    String string2 = this.utfToMime(string);
                    if (string2 == null || arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
            }
        }
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        return stringArray3;
    }

    @Override
    public String toString() {
        return "Mac OS X " + this.pasteboard.getName() + " Clipboard";
    }

    private synchronized String utfToMime(String string) {
        if (utm == null) {
            utm = new HashMap(6);
            utm.put("public.utf8-plain-text", "text/plain");
            utm.put("public.html", "text/html");
            utm.put("public.rtf", "text/rtf");
            utm.put("public.url", "text/uri-list");
            utm.put("public.file-url", "application/x-java-file-list");
            utm.put("public.tiff", "application/x-java-rawimage");
            utm.put("public.png", "application/x-java-rawimage");
        }
        if (utm.containsKey(string)) {
            return (String)utm.get(string);
        }
        return string;
    }

    private synchronized String mimeToUtf(String string) {
        if (mtu == null) {
            mtu = new HashMap(4);
            mtu.put("text/plain", "public.utf8-plain-text");
            mtu.put("text/html", "public.html");
            mtu.put("text/rtf", "public.rtf");
            mtu.put("text/uri-list", "public.url");
            mtu.put("application/x-java-file-list", "public.file-url");
        }
        if (mtu.containsKey(string)) {
            return (String)mtu.get(string);
        }
        return string;
    }

    private URI createUri(String string, String string2) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(string2 + string);
            Thread.dumpStack();
        }
        return uRI;
    }

    private URI createUri(String string, String string2, String string3) {
        URI uRI = null;
        try {
            uRI = new URI(string, null, string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(string3 + string2);
            Thread.dumpStack();
        }
        return uRI;
    }

    private URL createUrl(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(string2 + string);
            Thread.dumpStack();
        }
        return uRL;
    }

    private byte[] serialize(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return string.getBytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            return byteBuffer.array();
        }
        throw new RuntimeException("can not handle " + object);
    }
}

