/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.shared.common.error.ExceptionUtil;

public class LOBOutputStream
extends OutputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;

    LOBOutputStream(LOBStreamControl lOBStreamControl, long l) {
        this.control = lOBStreamControl;
        this.pos = l;
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            this.pos = this.control.write(n, this.pos);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        catch (StandardException standardException) {
            throw new IOException(standardException.getMessage());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            this.pos = this.control.write(byArray, n, n2, this.pos);
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(sQLException.getMessage());
            }
            throw new IOException(sQLException.getMessage());
        }
        catch (StandardException standardException) {
            throw new IOException(standardException.getMessage());
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

