/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = String.valueOf('.');
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR = String.valueOf('$');
    private static Map primitiveWrapperMap = new HashMap();
    private static Map abbreviationMap;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$org$apache$commons$lang$ClassUtils;

    public static String getShortClassName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getShortClassName(object.getClass().getName());
    }

    public static String getShortClassName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '.') {
                n = n2 + 1;
            } else if (cArray[n2] == '$') {
                cArray[n2] = 46;
            }
            ++n2;
        }
        return new String(cArray, n, cArray.length - n);
    }

    public static String getPackageName(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ClassUtils.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static List getAllSuperclasses(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Class clazz2 = clazz.getSuperclass();
        while (clazz2 != null) {
            arrayList.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    public static List getAllInterfaces(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (!arrayList.contains(classArray[n])) {
                    arrayList.add(classArray[n]);
                }
                List list = ClassUtils.getAllInterfaces(classArray[n]);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Class clazz2 = (Class)iterator.next();
                    if (arrayList.contains(clazz2)) continue;
                    arrayList.add(clazz2);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    public static List convertClassNamesToClasses(List list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                arrayList.add(Class.forName(string));
            }
            catch (Exception exception) {
                arrayList.add(null);
            }
        }
        return arrayList;
    }

    public static List convertClassesToClassNames(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (clazz == null) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(clazz.getName());
        }
        return arrayList;
    }

    public static boolean isAssignable(Class[] classArray, Class[] classArray2) {
        if (!ArrayUtils.isSameLength(classArray, classArray2)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (classArray2 == null) {
            classArray2 = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        int n = 0;
        while (n < classArray.length) {
            if (!ClassUtils.isAssignable(classArray[n], classArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return false;
        }
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (!clazz2.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(clazz)) {
                return Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Long.TYPE.equals(clazz)) {
                return Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Boolean.TYPE.equals(clazz)) {
                return false;
            }
            if (Double.TYPE.equals(clazz)) {
                return false;
            }
            if (Float.TYPE.equals(clazz)) {
                return Double.TYPE.equals(clazz2);
            }
            if (Character.TYPE.equals(clazz)) {
                return Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Short.TYPE.equals(clazz)) {
                return Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            if (Byte.TYPE.equals(clazz)) {
                return Short.TYPE.equals(clazz2) || Integer.TYPE.equals(clazz2) || Long.TYPE.equals(clazz2) || Float.TYPE.equals(clazz2) || Double.TYPE.equals(clazz2);
            }
            return false;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static Class primitiveToWrapper(Class clazz) {
        Class clazz2 = clazz;
        if (clazz != null && clazz.isPrimitive()) {
            clazz2 = (Class)primitiveWrapperMap.get(clazz);
        }
        return clazz2;
    }

    public static Class[] primitivesToWrappers(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        if (classArray.length == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            classArray2[n] = ClassUtils.primitiveToWrapper(classArray[n]);
            ++n;
        }
        return classArray2;
    }

    public static boolean isInnerClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.getName().indexOf(36) >= 0;
    }

    public static Class getClass(ClassLoader classLoader, String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        if (abbreviationMap.containsKey(string)) {
            String string2 = "[" + abbreviationMap.get(string);
            clazz = Class.forName(string2, bl, classLoader).getComponentType();
        } else {
            clazz = Class.forName(ClassUtils.toProperClassName(string), bl, classLoader);
        }
        return clazz;
    }

    public static Class getClass(ClassLoader classLoader, String string) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, string, true);
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        return ClassUtils.getClass(string, true);
    }

    public static Class getClass(String string, boolean bl) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = classLoader == null ? (class$org$apache$commons$lang$ClassUtils == null ? (class$org$apache$commons$lang$ClassUtils = ClassUtils.class$("org.apache.commons.lang.ClassUtils")) : class$org$apache$commons$lang$ClassUtils).getClassLoader() : classLoader;
        return ClassUtils.getClass(classLoader2, string, bl);
    }

    public static Method getPublicMethod(Class clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        Method method = clazz.getMethod(string, classArray);
        if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ClassUtils.getAllInterfaces(clazz));
        arrayList.addAll(ClassUtils.getAllSuperclasses(clazz));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Method method2;
            Class clazz2 = (Class)iterator.next();
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                method2 = clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (!Modifier.isPublic(method2.getDeclaringClass().getModifiers())) continue;
            return method2;
        }
        throw new NoSuchMethodException("Can't find a public method for " + string + " " + ArrayUtils.toString(classArray));
    }

    private static String toProperClassName(String string) {
        if ((string = StringUtils.deleteWhitespace(string)) == null) {
            throw new NullArgumentException("className");
        }
        if (string.endsWith("[]")) {
            StringBuffer stringBuffer = new StringBuffer();
            while (string.endsWith("[]")) {
                string = string.substring(0, string.length() - 2);
                stringBuffer.append("[");
            }
            String string2 = (String)abbreviationMap.get(string);
            if (string2 != null) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append("L").append(string).append(";");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitiveWrapperMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitiveWrapperMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveWrapperMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveWrapperMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveWrapperMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveWrapperMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveWrapperMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        abbreviationMap = new HashMap();
        abbreviationMap.put("int", "I");
        abbreviationMap.put("boolean", "Z");
        abbreviationMap.put("float", "F");
        abbreviationMap.put("long", "J");
        abbreviationMap.put("short", "S");
        abbreviationMap.put("byte", "B");
        abbreviationMap.put("double", "D");
        abbreviationMap.put("char", "C");
    }
}

