/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class HashCodeBuilder {
    private final int iConstant;
    private int iTotal = 0;

    public HashCodeBuilder() {
        this.iConstant = 37;
        this.iTotal = 17;
    }

    public HashCodeBuilder(int n, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires a non zero initial value");
        }
        if (n % 2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires an odd initial value");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires a non zero multiplier");
        }
        if (n2 % 2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires an odd multiplier");
        }
        this.iConstant = n2;
        this.iTotal = n;
    }

    public static int reflectionHashCode(Object object) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, false, null, null);
    }

    public static int reflectionHashCode(Object object, Collection collection) {
        return HashCodeBuilder.reflectionHashCode(object, ReflectionToStringBuilder.toNoNullStringArray(collection));
    }

    public static int reflectionHashCode(Object object, String[] stringArray) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, false, null, stringArray);
    }

    public static int reflectionHashCode(Object object, boolean bl) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, bl, null, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object) {
        return HashCodeBuilder.reflectionHashCode(n, n2, object, false, null, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object, boolean bl) {
        return HashCodeBuilder.reflectionHashCode(n, n2, object, bl, null, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object, boolean bl, Class clazz) {
        return HashCodeBuilder.reflectionHashCode(n, n2, object, bl, clazz, null);
    }

    public static int reflectionHashCode(int n, int n2, Object object, boolean bl, Class clazz, String[] stringArray) {
        if (object == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(n, n2);
        Class<?> clazz2 = object.getClass();
        HashCodeBuilder.reflectionAppend(object, clazz2, hashCodeBuilder, bl, stringArray);
        while (clazz2.getSuperclass() != null && clazz2 != clazz) {
            clazz2 = clazz2.getSuperclass();
            HashCodeBuilder.reflectionAppend(object, clazz2, hashCodeBuilder, bl, stringArray);
        }
        return hashCodeBuilder.toHashCode();
    }

    private static void reflectionAppend(Object object, Class clazz, HashCodeBuilder hashCodeBuilder, boolean bl, String[] stringArray) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        List<String> list = stringArray != null ? Arrays.asList(stringArray) : Collections.EMPTY_LIST;
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        int n = 0;
        while (n < accessibleObjectArray.length) {
            AccessibleObject accessibleObject = accessibleObjectArray[n];
            if (!(list.contains(((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().indexOf(36) != -1 || !bl && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers()))) {
                try {
                    hashCodeBuilder.append(((Field)accessibleObject).get(object));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            ++n;
        }
    }

    public HashCodeBuilder appendSuper(int n) {
        this.iTotal = this.iTotal * this.iConstant + n;
        return this;
    }

    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (!object.getClass().isArray()) {
            this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        } else if (object instanceof long[]) {
            this.append((long[])object);
        } else if (object instanceof int[]) {
            this.append((int[])object);
        } else if (object instanceof short[]) {
            this.append((short[])object);
        } else if (object instanceof char[]) {
            this.append((char[])object);
        } else if (object instanceof byte[]) {
            this.append((byte[])object);
        } else if (object instanceof double[]) {
            this.append((double[])object);
        } else if (object instanceof float[]) {
            this.append((float[])object);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object);
        } else {
            this.append((Object[])object);
        }
        return this;
    }

    public HashCodeBuilder append(long l) {
        this.iTotal = this.iTotal * this.iConstant + (int)(l ^ l >> 32);
        return this;
    }

    public HashCodeBuilder append(int n) {
        this.iTotal = this.iTotal * this.iConstant + n;
        return this;
    }

    public HashCodeBuilder append(short s) {
        this.iTotal = this.iTotal * this.iConstant + s;
        return this;
    }

    public HashCodeBuilder append(char c) {
        this.iTotal = this.iTotal * this.iConstant + c;
        return this;
    }

    public HashCodeBuilder append(byte by) {
        this.iTotal = this.iTotal * this.iConstant + by;
        return this;
    }

    public HashCodeBuilder append(double d) {
        return this.append(Double.doubleToLongBits(d));
    }

    public HashCodeBuilder append(float f) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(f);
        return this;
    }

    public HashCodeBuilder append(boolean bl) {
        this.iTotal = this.iTotal * this.iConstant + (bl ? 0 : 1);
        return this;
    }

    public HashCodeBuilder append(Object[] objectArray) {
        if (objectArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < objectArray.length) {
                this.append(objectArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(long[] lArray) {
        if (lArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < lArray.length) {
                this.append(lArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(int[] nArray) {
        if (nArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < nArray.length) {
                this.append(nArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(short[] sArray) {
        if (sArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < sArray.length) {
                this.append(sArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(char[] cArray) {
        if (cArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < cArray.length) {
                this.append(cArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(byte[] byArray) {
        if (byArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < byArray.length) {
                this.append(byArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(double[] dArray) {
        if (dArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < dArray.length) {
                this.append(dArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(float[] fArray) {
        if (fArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < fArray.length) {
                this.append(fArray[n]);
                ++n;
            }
        }
        return this;
    }

    public HashCodeBuilder append(boolean[] blArray) {
        if (blArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            int n = 0;
            while (n < blArray.length) {
                this.append(blArray[n]);
                ++n;
            }
        }
        return this;
    }

    public int toHashCode() {
        return this.iTotal;
    }
}

