/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import java.io.Serializable;
import org.apache.commons.lang.math.Range;

public final class NumberRange
extends Range
implements Serializable {
    private static final long serialVersionUID = 71849363892710L;
    private final Number min;
    private final Number max;
    private transient int hashCode = 0;
    private transient String toString = null;

    public NumberRange(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("The number must not be null");
        }
        if (!(number instanceof Comparable)) {
            throw new IllegalArgumentException("The number must implement Comparable");
        }
        if (number instanceof Double && ((Double)number).isNaN()) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        if (number instanceof Float && ((Float)number).isNaN()) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        this.min = number;
        this.max = number;
    }

    public NumberRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("The numbers must not be null");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("The numbers must be of the same type");
        }
        if (!(number instanceof Comparable)) {
            throw new IllegalArgumentException("The numbers must implement Comparable");
        }
        if (number instanceof Double ? ((Double)number).isNaN() || ((Double)number2).isNaN() : number instanceof Float && (((Float)number).isNaN() || ((Float)number2).isNaN())) {
            throw new IllegalArgumentException("The number must not be NaN");
        }
        int n = ((Comparable)((Object)number)).compareTo(number2);
        if (n == 0) {
            this.min = number;
            this.max = number;
        } else if (n > 0) {
            this.min = number2;
            this.max = number;
        } else {
            this.min = number;
            this.max = number2;
        }
    }

    public Number getMinimumNumber() {
        return this.min;
    }

    public Number getMaximumNumber() {
        return this.max;
    }

    public boolean containsNumber(Number number) {
        if (number == null) {
            return false;
        }
        if (number.getClass() != this.min.getClass()) {
            throw new IllegalArgumentException("The number must be of the same type as the range numbers");
        }
        int n = ((Comparable)((Object)this.min)).compareTo(number);
        int n2 = ((Comparable)((Object)this.max)).compareTo(number);
        return n <= 0 && n2 >= 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberRange)) {
            return false;
        }
        NumberRange numberRange = (NumberRange)object;
        return this.min.equals(numberRange.min) && this.max.equals(numberRange.max);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().hashCode();
            this.hashCode = 37 * this.hashCode + this.min.hashCode();
            this.hashCode = 37 * this.hashCode + this.max.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append("Range[");
            stringBuffer.append(this.min);
            stringBuffer.append(',');
            stringBuffer.append(this.max);
            stringBuffer.append(']');
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }
}

