/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public class DateUtils {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;
    public static final int MILLIS_IN_SECOND = 1000;
    public static final int MILLIS_IN_MINUTE = 60000;
    public static final int MILLIS_IN_HOUR = 3600000;
    public static final int MILLIS_IN_DAY = 86400000;

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameInstant(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(10) == calendar2.get(10) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Date parseDate(String string, String[] stringArray) throws ParseException {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat simpleDateFormat = null;
        ParsePosition parsePosition = new ParsePosition(0);
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                simpleDateFormat = new SimpleDateFormat(stringArray[0]);
            } else {
                simpleDateFormat.applyPattern(stringArray[n]);
            }
            parsePosition.setIndex(0);
            Date date = simpleDateFormat.parse(string, parsePosition);
            if (date != null && parsePosition.getIndex() == string.length()) {
                return date;
            }
            ++n;
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    public static Date addYears(Date date, int n) {
        return DateUtils.add(date, 1, n);
    }

    public static Date addMonths(Date date, int n) {
        return DateUtils.add(date, 2, n);
    }

    public static Date addWeeks(Date date, int n) {
        return DateUtils.add(date, 3, n);
    }

    public static Date addDays(Date date, int n) {
        return DateUtils.add(date, 5, n);
    }

    public static Date addHours(Date date, int n) {
        return DateUtils.add(date, 11, n);
    }

    public static Date addMinutes(Date date, int n) {
        return DateUtils.add(date, 12, n);
    }

    public static Date addSeconds(Date date, int n) {
        return DateUtils.add(date, 13, n);
    }

    public static Date addMilliseconds(Date date, int n) {
        return DateUtils.add(date, 14, n);
    }

    public static Date add(Date date, int n, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n, n2);
        return calendar.getTime();
    }

    public static Date round(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, true);
        return calendar.getTime();
    }

    public static Calendar round(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, true);
        return calendar2;
    }

    public static Date round(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    public static Date truncate(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, false);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, false);
        return calendar2;
    }

    public static Date truncate(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    private static void modify(Calendar calendar, int n, boolean bl) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n == 14) {
            return;
        }
        Date date = calendar.getTime();
        long l = date.getTime();
        boolean bl2 = false;
        int n2 = calendar.get(14);
        if (!bl || n2 < 500) {
            l -= (long)n2;
            if (n == 13) {
                bl2 = true;
            }
        }
        int n3 = calendar.get(13);
        if (!(bl2 || bl && n3 >= 30)) {
            l -= (long)n3 * 1000L;
            if (n == 12) {
                bl2 = true;
            }
        }
        int n4 = calendar.get(12);
        if (!(bl2 || bl && n4 >= 30)) {
            l -= (long)n4 * 60000L;
        }
        if (date.getTime() != l) {
            date.setTime(l);
            calendar.setTime(date);
        }
        boolean bl3 = false;
        int n5 = 0;
        while (n5 < fields.length) {
            int n6 = 0;
            while (n6 < fields[n5].length) {
                if (fields[n5][n6] == n) {
                    if (bl && bl3) {
                        if (n == 1001) {
                            if (calendar.get(5) == 1) {
                                calendar.add(5, 15);
                            } else {
                                calendar.add(5, -15);
                                calendar.add(2, 1);
                            }
                        } else {
                            calendar.add(fields[n5][0], 1);
                        }
                    }
                    return;
                }
                ++n6;
            }
            int n7 = 0;
            boolean bl4 = false;
            switch (n) {
                case 1001: {
                    if (fields[n5][0] != 5) break;
                    n7 = calendar.get(5) - 1;
                    if (n7 >= 15) {
                        n7 -= 15;
                    }
                    bl3 = n7 > 7;
                    bl4 = true;
                    break;
                }
                case 9: {
                    if (fields[n5][0] != 11) break;
                    n7 = calendar.get(11);
                    if (n7 >= 12) {
                        n7 -= 12;
                    }
                    bl3 = n7 > 6;
                    bl4 = true;
                }
            }
            if (!bl4) {
                int n8 = calendar.getActualMinimum(fields[n5][0]);
                int n9 = calendar.getActualMaximum(fields[n5][0]);
                n7 = calendar.get(fields[n5][0]) - n8;
                boolean bl5 = bl3 = n7 > (n9 - n8) / 2;
            }
            if (n7 != 0) {
                calendar.set(fields[n5][0], calendar.get(fields[n5][0]) - n7);
            }
            ++n5;
        }
        throw new IllegalArgumentException("The field " + n + " is not supported");
    }

    public static Iterator iterator(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.iterator(calendar, n);
    }

    public static Iterator iterator(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = null;
        Calendar calendar3 = null;
        int n2 = 1;
        int n3 = 7;
        switch (n) {
            case 5: 
            case 6: {
                calendar2 = DateUtils.truncate(calendar, 2);
                calendar3 = (Calendar)calendar2.clone();
                calendar3.add(2, 1);
                calendar3.add(5, -1);
                if (n != 6) break;
                n2 = 2;
                n3 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar2 = DateUtils.truncate(calendar, 5);
                calendar3 = DateUtils.truncate(calendar, 5);
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        n2 = calendar.get(7);
                        n3 = n2 - 1;
                        break;
                    }
                    case 4: {
                        n2 = calendar.get(7) - 3;
                        n3 = calendar.get(7) + 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + n + " is not valid.");
            }
        }
        if (n2 < 1) {
            n2 += 7;
        }
        if (n2 > 7) {
            n2 -= 7;
        }
        if (n3 < 1) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        while (calendar2.get(7) != n2) {
            calendar2.add(5, -1);
        }
        while (calendar3.get(7) != n3) {
            calendar3.add(5, 1);
        }
        return new DateIterator(calendar2, calendar3);
    }

    public static Iterator iterator(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    static class DateIterator
    implements Iterator {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar calendar, Calendar calendar2) {
            this.endFinal = calendar2;
            this.spot = calendar;
            this.spot.add(5, -1);
        }

        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        public Object next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return this.spot.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

