/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.core.NestedExceptionUtils;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5439915454935047936L;
    private Throwable cause;

    public NestedRuntimeException(String string) {
        super(string);
    }

    public NestedRuntimeException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        return NestedExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.getCause() == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.println(this);
            printStream.print("Caused by: ");
            this.getCause().printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.getCause() == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.println(this);
            printWriter.print("Caused by: ");
            this.getCause().printStackTrace(printWriter);
        }
    }

    public Throwable getRootCause() {
        Throwable throwable = this.getCause();
        if (throwable instanceof NestedRuntimeException) {
            Throwable throwable2 = ((NestedRuntimeException)throwable).getRootCause();
            return throwable2 != null ? throwable2 : throwable;
        }
        return throwable;
    }

    public Throwable getMostSpecificCause() {
        Throwable throwable = this.getRootCause();
        return throwable != null ? throwable : this;
    }

    public boolean contains(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isInstance(this)) {
            return true;
        }
        Throwable throwable = this.getCause();
        if (throwable instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)throwable).contains(clazz);
        }
        return throwable != null && clazz.isInstance(throwable);
    }
}

